/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.lucenecompat.spring;

import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.index.api.Extractor2;
import com.atlassian.confluence.plugin.descriptor.ExtractorModuleDescriptor;
import com.atlassian.labs.lucenecompat.spi.ExtractorFactory;
import com.atlassian.labs.lucenecompat.spi.ExtractorModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DynamicExtractorModuleDescriptorsFactory
implements FactoryBean,
DisposableBean,
ApplicationContextAware,
InitializingBean {
    private static String extractorModuleDescriptorFactoryClazz;
    private static String extractorFactoryClazz;
    private static boolean runningConfluenceVersion5_2orNewer;
    private Collection<Extractor2> extractors;
    private AutowireCapableBeanFactory beanFactory;
    private BundleContext bundleContext;
    private ModuleFactory moduleFactory;
    private PluginAccessor pluginAccessor;
    private ServiceRegistration serviceRegistration;

    private static boolean isLucene4() {
        try {
            Class.forName("org.apache.lucene.index.IndexableField", false, LuceneConnection.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Autowired
    public DynamicExtractorModuleDescriptorsFactory(AutowireCapableBeanFactory beanFactory, BundleContext bundleContext, ModuleFactory moduleFactory, PluginAccessor pluginAccessor) {
        this.beanFactory = beanFactory;
        this.bundleContext = bundleContext;
        this.moduleFactory = moduleFactory;
        this.pluginAccessor = pluginAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.getObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getObject() throws Exception {
        if (runningConfluenceVersion5_2orNewer) {
            return null;
        }
        Class<?> extractorFactoryClass = this.getClass().getClassLoader().loadClass(extractorFactoryClazz);
        ExtractorFactory extractorFactory = (ExtractorFactory)this.beanFactory.createBean(extractorFactoryClass);
        Class<?> extractorModuleDescriptorFactoryClass = this.getClass().getClassLoader().loadClass(extractorModuleDescriptorFactoryClazz);
        ExtractorModuleDescriptorFactory extractorModuleDescriptorFactory = (ExtractorModuleDescriptorFactory)this.beanFactory.createBean(extractorModuleDescriptorFactoryClass);
        ExtractorModuleDescriptor extractorModuleDescriptor = extractorModuleDescriptorFactory.createExtractorModuleDescriptor(new CompatibilityExtractor(this.extractors, extractorFactory), this.moduleFactory);
        Plugin plugin = this.pluginAccessor.getPlugin(DynamicExtractorModuleDescriptorsFactory.getPluginKey(this.bundleContext.getBundle()));
        Element extractorElement = DocumentHelper.createElement((String)"extractor").addAttribute("key", "extractor-" + UUID.randomUUID());
        extractorModuleDescriptor.init(plugin, extractorElement);
        this.serviceRegistration = this.bundleContext.registerService(ModuleDescriptor.class.getName(), (Object)extractorModuleDescriptor, null);
        return null;
    }

    static String getPluginKey(Bundle bundle) {
        return DynamicExtractorModuleDescriptorsFactory.getPluginKey(bundle.getSymbolicName(), bundle.getHeaders().get("Atlassian-Plugin-Key"), bundle.getHeaders().get("Bundle-Version"));
    }

    private static String getPluginKey(Object bundleName, Object atlKey, Object version) {
        Object key = atlKey;
        if (key == null) {
            key = bundleName + "-" + version;
        }
        return key.toString();
    }

    public void destroy() throws Exception {
        if (this.serviceRegistration != null) {
            try {
                this.serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public Class getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setModuleFactory(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.extractors = applicationContext.getBeansOfType(Extractor2.class).values();
    }

    static {
        runningConfluenceVersion5_2orNewer = false;
        extractorFactoryClazz = "com.atlassian.labs.lucenecompat.impl.Lucene29" + ExtractorFactory.class.getSimpleName();
        try {
            ExtractorModuleDescriptor.class.getConstructor(new Class[0]);
            extractorModuleDescriptorFactoryClazz = "com.atlassian.labs.lucenecompat.impl.Lucene29" + ExtractorModuleDescriptorFactory.class.getSimpleName();
        }
        catch (NoSuchMethodException e) {
            extractorModuleDescriptorFactoryClazz = "com.atlassian.labs.lucenecompat.impl.Lucene4" + ExtractorModuleDescriptorFactory.class.getSimpleName();
        }
        try {
            runningConfluenceVersion5_2orNewer = DynamicExtractorModuleDescriptorsFactory.isLucene4();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompatibilityExtractor
    implements Extractor {
        private final Iterable<Extractor2> extractors;
        private final ExtractorFactory extractorFactory;

        public CompatibilityExtractor(Iterable<Extractor2> extractors, ExtractorFactory extractorFactory) {
            this.extractors = extractors;
            this.extractorFactory = extractorFactory;
        }

        public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
            for (Extractor2 extractor : this.extractors) {
                this.extractorFactory.convert(extractor).addFields(document, defaultSearchableText, searchable);
            }
        }
    }
}

