/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.lucenecompat.impl;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.index.Lucene29FieldDescriptorMapper;
import com.atlassian.confluence.index.api.Extractor2;
import com.atlassian.confluence.index.api.FieldDescriptor;
import com.atlassian.confluence.index.api.FieldDescriptorMapper;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;

public class Lucene29AdaptingExtractor
implements Extractor {
    private final Extractor2 delegate;
    private final FieldDescriptorMapper fieldDescriptorMapper;

    public Lucene29AdaptingExtractor(Extractor2 delegate) {
        this.delegate = delegate;
        this.fieldDescriptorMapper = new Lucene29FieldDescriptorMapper();
    }

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        StringBuilder buffer;
        Collection<FieldDescriptor> fieldDescriptors = this.delegate.extractFields(searchable);
        if (fieldDescriptors != null) {
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Object field = this.fieldDescriptorMapper.map(fieldDescriptor);
                if (!(field instanceof Fieldable)) continue;
                document.add((Fieldable)field);
            }
        }
        if ((buffer = this.delegate.extractText(searchable)) != null) {
            defaultSearchableText.append(' ').append((CharSequence)buffer);
        }
    }
}

