/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@NotThreadSafe
class MemorySavingConcatIterator<T>
implements Iterator<T> {
    private final Deque<Iterator<T>> iterators;

    public static <T> Iterator<T> concat(Iterator<T> iterators1, Iterator<T> iterator2) {
        return MemorySavingConcatIterator.concat(Arrays.asList(Objects.requireNonNull(iterators1), Objects.requireNonNull(iterator2)));
    }

    public static <T> Iterator<T> concat(Iterable<Iterator<T>> iterators) {
        return new MemorySavingConcatIterator<T>(Lists.newLinkedList(iterators));
    }

    private MemorySavingConcatIterator(Deque<Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        Iterator<T> firstIterator = this.iterators.peekFirst();
        if (firstIterator != null) {
            if (firstIterator.hasNext()) {
                return true;
            }
            this.iterators.removeFirst();
            return false;
        }
        return false;
    }

    @Override
    public T next() {
        Iterator<T> firstIterator = this.iterators.peekFirst();
        if (firstIterator != null) {
            T next = firstIterator.next();
            if (!firstIterator.hasNext()) {
                this.iterators.removeFirst();
            }
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

