/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.util;

import org.apache.lucene.document.Document;

public class LuceneDoc {
    public static final String AUTHOR_CONTRIBUTIONS = "authorContributions";
    public static final String LABEL_CONTRIBUTIONS = "labelContributions";
    public static final String WATCHERS = "watchers";
    public static final String ANCESTOR_IDS = "ancestorIds";
    public static final String KEY = "key";
    public static final String MODIFIED = "modified";
    public static final String LAST_MODIFIER_NAME = "lastModifierName";
    private final Document luceneDocument;

    public LuceneDoc(Document luceneDocument) {
        this.luceneDocument = luceneDocument;
    }

    public String getTitle() {
        return this.luceneDocument.get("title");
    }

    public String getUrlPath() {
        return this.luceneDocument.get("urlPath");
    }

    public String[] getAuthorContributions() {
        return this.luceneDocument.getValues(AUTHOR_CONTRIBUTIONS);
    }

    public String[] getLabelContributions() {
        return this.luceneDocument.getValues(LABEL_CONTRIBUTIONS);
    }

    public String getSpaceKey() {
        return this.luceneDocument.get("spacekey");
    }

    public String[] getWatchers() {
        return this.luceneDocument.getValues(WATCHERS);
    }

    public String getHandle() {
        return this.luceneDocument.get("handle");
    }

    public String getAncestorIds() {
        return this.luceneDocument.get(ANCESTOR_IDS);
    }

    public String getKey() {
        return this.luceneDocument.get(KEY);
    }

    public String getPageUrlPath() {
        return this.luceneDocument.get("page.urlPath");
    }

    public String getPageDisplayTitle() {
        return this.luceneDocument.get("page.realTitle");
    }

    public String getModified() {
        return this.luceneDocument.get(MODIFIED);
    }

    public String getLastModifierName() {
        return this.luceneDocument.get(LAST_MODIFIER_NAME);
    }
}

