/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.util;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.contributors.search.lucene.BaseCollector;
import com.atlassian.confluence.contributors.search.query.CreationDateQuery;
import com.atlassian.confluence.contributors.search.query.KeywordQuery;
import com.atlassian.confluence.contributors.search.query.NoResultQuery;
import com.atlassian.confluence.contributors.util.LuceneDoc;
import com.atlassian.confluence.contributors.util.MemorySavingConcatIterator;
import com.atlassian.confluence.contributors.util.PageSearchHelper;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResultType;
import com.atlassian.confluence.search.v2.lucene.LuceneSearchMapper;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.searchfilter.ChainedSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SpacePermissionsSearchFilter;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageSearchHelper
implements PageSearchHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageSearchHelper.class);
    public static final String SCOPE_CHILDREN = "children";
    public static final String SCOPE_DESCENDANTS = "descendants";
    public static final String SPACES_ALL = "@all";
    public static final String SPACES_GLOBAL = "@global";
    public static final String SPACES_PERSONAL = "@personal";
    private final ILuceneConnection luceneConnection;
    private final QueryAndFilterFactory queryAndFilterFactory;
    private static ImmutableSet<String> FIELDS_TO_LOAD = ImmutableSet.builder().add((Object)"title").add((Object)"spacekey").add((Object)"handle").add((Object)"urlPath").add((Object)"watchers").add((Object)"authorContributions").add((Object)"page.urlPath").add((Object)"page.realTitle").add((Object)"labelContributions").add((Object)"ancestorIds").add((Object)"modified").add((Object)"lastModifierName").add((Object)"key").build();

    public DefaultPageSearchHelper(SpaceManager spaceManager, PermissionManager permissionManager, ILuceneConnection luceneConnection, LuceneSearchMapper luceneSearchMapper) {
        this.luceneConnection = luceneConnection;
        this.queryAndFilterFactory = new QueryAndFilterFactory(spaceManager, permissionManager, luceneSearchMapper);
    }

    @Override
    public PageSearchHelper.Result getDocuments(String page, String spaceKey, String labels, String scope, Date publishDate, String contentType) {
        return this.search(this.queryAndFilterFactory.getQuery(page, spaceKey, labels, publishDate, contentType), this.queryAndFilterFactory.permissionsFilter(), DefaultPageSearchHelper.includePageHierarchy(scope, contentType)).createResultIterator(scope);
    }

    private Iterator<LuceneDoc> fetchDocs(Iterable<HibernateHandle> handles, int partitionSize) {
        List partitions = Lists.partition((List)Lists.newArrayList(handles), (int)partitionSize);
        return MemorySavingConcatIterator.concat(Iterables.transform((Iterable)partitions, (Function)new Function<List<HibernateHandle>, Iterator<LuceneDoc>>(){

            public Iterator<LuceneDoc> apply(List<HibernateHandle> input) {
                return DefaultPageSearchHelper.this.fetchDocs(input).iterator();
            }
        }));
    }

    private Iterable<LuceneDoc> fetchDocs(final Iterable<HibernateHandle> handles) {
        return (Iterable)this.luceneConnection.withSearcher((ILuceneConnection.SearcherWithTokenAction)new ILuceneConnection.SearcherWithTokenAction<Iterable<LuceneDoc>>(){

            public Iterable<LuceneDoc> perform(IndexSearcher searcher, long unusedToken) throws IOException {
                return DefaultPageSearchHelper.this.fetchDocs((Iterable<HibernateHandle>)handles, searcher);
            }
        });
    }

    private Collection<LuceneDoc> fetchDocs(Iterable<HibernateHandle> handles, IndexSearcher indexSearcher) throws IOException {
        ArrayList fetchedDocs = Lists.newArrayList();
        Filter filter = DefaultPageSearchHelper.filterByHandles(handles);
        log.debug("Search for handles {} using filter {}", handles, (Object)filter);
        Set<Integer> docIds = DefaultPageSearchHelper.searchForDocIds(indexSearcher, filter, (Query)new MatchAllDocsQuery());
        log.debug("Fetching lucene documents {}", docIds);
        for (Integer docId : docIds) {
            Document document = indexSearcher.doc(docId.intValue(), FIELDS_TO_LOAD);
            if (document != null) {
                fetchedDocs.add(new LuceneDoc(document));
                continue;
            }
            log.debug("No lucene document found for id {}", (Object)docId);
        }
        return fetchedDocs;
    }

    private static Filter filterByHandles(Iterable<HibernateHandle> handles) {
        ArrayList terms = Lists.newArrayList();
        for (HibernateHandle handle : handles) {
            terms.add(new Term("handle", handle.toString()));
        }
        return new TermsFilter((List)terms);
    }

    private static Set<Integer> searchForDocIds(IndexSearcher indexSearcher, Filter filter, Query query) throws IOException {
        final HashSet docIds = Sets.newHashSet();
        indexSearcher.search(query, filter, (Collector)new BaseCollector(){

            public void collect(int doc) throws IOException {
                docIds.add(this.docBase + doc);
            }
        });
        return docIds;
    }

    private ResultsCollector search(final Query query, final Filter filter, final boolean includePageHierarchy) {
        final ResultsCollector resultsCollector = new ResultsCollector();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            public void perform(IndexSearcher indexSearcher) throws IOException {
                log.debug("Searching for parent docs using {} and {}", (Object)query, (Object)filter);
                try (DocCollector docCollector = resultsCollector.newParentDocCollector(indexSearcher);){
                    indexSearcher.search(query, filter, (Collector)docCollector);
                }
                log.debug("Query found {} results: {}", (Object)resultsCollector.parentHandles.size(), (Object)resultsCollector.parentHandles);
                if (includePageHierarchy && !resultsCollector.parentHandles.isEmpty()) {
                    Filter parentFilter = DefaultPageSearchHelper.this.queryAndFilterFactory.createParentFilter(resultsCollector.parentHandles);
                    try (DocCollector childDocCollector = resultsCollector.newChildDocCollector(indexSearcher);){
                        indexSearcher.search((Query)new MatchAllDocsQuery(), parentFilter, (Collector)childDocCollector);
                    }
                }
            }
        });
        return resultsCollector;
    }

    private static boolean includePageHierarchy(String scope, String contentType) {
        return scope != null && !"blogpost".equals(contentType);
    }

    private static boolean isChild(LuceneDoc document, Collection<Long> parentIds) {
        String ancestorIds = document.getAncestorIds();
        if (ancestorIds != null) {
            Long parentId = Long.parseLong(ancestorIds.substring(ancestorIds.lastIndexOf(" ") + 1));
            return parentIds.contains(parentId);
        }
        return false;
    }

    private static Set<HibernateHandle> extractPageHandles(Collection<Integer> docIds, IndexSearcher indexSearcher) throws IOException {
        HashSet handles = Sets.newHashSetWithExpectedSize((int)docIds.size());
        for (Integer docId : docIds) {
            Document doc = indexSearcher.doc(docId.intValue(), Collections.singleton("handle"));
            try {
                handles.add(new HibernateHandle(new LuceneDoc(doc).getHandle()));
            }
            catch (ParseException parseException) {}
        }
        return handles;
    }

    private static class QueryAndFilterFactory {
        private static SearchFilter DEFAULT_PERMISSIONS_FILTER = new ChainedSearchFilter(new SearchFilter[]{SpacePermissionsSearchFilter.getInstance(), ContentPermissionsSearchFilter.getInstance()});
        private final SpaceManager spaceManager;
        private final PermissionManager permissionManager;
        private final LuceneSearchMapper luceneSearchMapper;

        private QueryAndFilterFactory(SpaceManager spaceManager, PermissionManager permissionManager, LuceneSearchMapper luceneSearchMapper) {
            this.spaceManager = spaceManager;
            this.permissionManager = permissionManager;
            this.luceneSearchMapper = luceneSearchMapper;
        }

        public Filter createParentFilter(Iterable<HibernateHandle> handles) {
            ArrayList parentTerms = Lists.newArrayList();
            ArrayList parentHandlesTerms = Lists.newArrayList();
            for (HibernateHandle handle : handles) {
                parentTerms.add(new Term("ancestorIds", Long.toString(handle.getId())));
                parentHandlesTerms.add(new Term("handle", handle.toString()));
            }
            return new ChainedFilter(new Filter[]{this.permissionsFilter(), new TermsFilter((List)parentTerms), new TermsFilter((List)parentHandlesTerms)}, new int[]{1, 1, 2});
        }

        private static Set<String> getSpaceKeys(ListBuilder<Space> spaces) {
            return QueryAndFilterFactory.getSpaceKeys(spaces.getPage(0, spaces.getAvailableSize()));
        }

        private static Set<String> getSpaceKeys(List<Space> spaces) {
            HashSet spaceKeys = Sets.newHashSetWithExpectedSize((int)spaces.size());
            for (Space space : spaces) {
                spaceKeys.add(space.getKey());
            }
            return spaceKeys;
        }

        private SearchQuery getSpacesQuery(String spaceKey) {
            Set<Object> spaceKeys = StringUtils.equals((CharSequence)DefaultPageSearchHelper.SPACES_ALL, (CharSequence)spaceKey) ? QueryAndFilterFactory.getSpaceKeys(this.spaceManager.getAllSpaces()) : (StringUtils.equals((CharSequence)DefaultPageSearchHelper.SPACES_GLOBAL, (CharSequence)spaceKey) ? QueryAndFilterFactory.getSpaceKeys((ListBuilder<Space>)this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build())) : (StringUtils.equals((CharSequence)DefaultPageSearchHelper.SPACES_PERSONAL, (CharSequence)spaceKey) ? QueryAndFilterFactory.getSpaceKeys((ListBuilder<Space>)this.spaceManager.getSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.PERSONAL).build())) : Sets.newHashSet(Arrays.asList(StringUtils.split((String)spaceKey, (String)" ,")))));
            if (spaceKeys.size() == 0) {
                return new NoResultQuery();
            }
            return new InSpaceQuery(spaceKeys);
        }

        private SearchQuery getContentQuery(String contentTitle, String contentType, String labelsString, Date publishedDate) {
            LinkedHashSet queries = Sets.newLinkedHashSet();
            queries.add(new KeywordQuery("confluence-document-type", SearchResultType.CONTENT.name()));
            queries.add(StringUtils.isBlank((CharSequence)contentType) ? new ContentTypeQuery(Arrays.asList(ContentTypeEnum.BLOG, ContentTypeEnum.PAGE)) : new ContentTypeQuery(StringUtils.equals((CharSequence)"page", (CharSequence)contentType) ? ContentTypeEnum.PAGE : ContentTypeEnum.BLOG));
            if (StringUtils.isNotBlank((CharSequence)contentTitle)) {
                queries.add(new KeywordQuery("content-name-untokenized", contentTitle));
            }
            if (StringUtils.isNotBlank((CharSequence)labelsString)) {
                String[] labels = StringUtils.split((String)labelsString, (String)" ,");
                HashSet labelQueries = Sets.newHashSetWithExpectedSize((int)labels.length);
                for (String labelName : StringUtils.split((String)labelsString, (String)" ,")) {
                    labelQueries.add(new LabelQuery(labelName));
                }
                queries.add(BooleanQuery.composeOrQuery((Set)labelQueries));
            }
            if (publishedDate != null) {
                queries.add(new CreationDateQuery(publishedDate, null));
            }
            return BooleanQuery.composeAndQuery((Set)queries);
        }

        private SearchQuery getPageListQuery(String pageName, String spaceKey, String labels, Date publishDate, String contentType) {
            ArrayList query = Lists.newArrayList();
            query.add(this.getSpacesQuery(spaceKey));
            query.add(this.getContentQuery(pageName, contentType, labels, publishDate));
            return BooleanQuery.composeAndQuery((Set)Sets.newHashSet((Iterable)query));
        }

        public Filter permissionsFilter() {
            SearchFilter filter = DEFAULT_PERMISSIONS_FILTER;
            if (this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get())) {
                filter = ContentPermissionsSearchFilter.getInstance();
            }
            return this.luceneSearchMapper.convertToLuceneSearchFilter(filter);
        }

        public Query getQuery(String page, String spaceKey, String labels, Date publishDate, String contentType) {
            SearchQuery searchQuery = this.getPageListQuery(page, spaceKey, labels, publishDate, contentType);
            return this.luceneSearchMapper.convertToLuceneQuery(searchQuery);
        }
    }

    private static class DocCollector
    extends BaseCollector
    implements AutoCloseable {
        private final Set<Integer> docIds = Sets.newHashSet();
        private final IndexSearcher indexSearcher;
        private final Collection<HibernateHandle> handlesTarget;

        public DocCollector(IndexSearcher indexSearcher, Collection<HibernateHandle> handlesTarget) {
            this.indexSearcher = indexSearcher;
            this.handlesTarget = handlesTarget;
        }

        public void collect(int docId) throws IOException {
            this.docIds.add(this.docBase + docId);
        }

        @Override
        public void close() throws IOException {
            this.handlesTarget.addAll(DefaultPageSearchHelper.extractPageHandles(this.docIds, this.indexSearcher));
            log.debug("Converted docIds {} into handles {}", this.docIds, this.handlesTarget);
        }
    }

    private class ResultsCollector {
        private final Set<HibernateHandle> parentHandles = Sets.newHashSet();
        private final Set<HibernateHandle> childHandles = Sets.newHashSet();

        private ResultsCollector() {
        }

        DocCollector newParentDocCollector(IndexSearcher indexSearcher) {
            return new DocCollector(indexSearcher, this.parentHandles);
        }

        DocCollector newChildDocCollector(IndexSearcher indexSearcher) {
            return new DocCollector(indexSearcher, this.childHandles);
        }

        ResultIterator createResultIterator(String scope) {
            return new ResultIterator(scope, this.parentHandles, this.childHandles);
        }
    }

    private class ResultIterator
    implements PageSearchHelper.Result {
        private static final int PARTITION_SIZE = 100;
        private final String scope;
        private final Set<HibernateHandle> parentHandles;
        private final Set<HibernateHandle> childHandles;

        private ResultIterator(String scope, Set<HibernateHandle> parentHandles, Set<HibernateHandle> childHandles) {
            this.scope = scope;
            this.parentHandles = parentHandles;
            this.childHandles = childHandles;
        }

        @Override
        public int size() {
            return this.parentHandles.size() + this.childHandles.size();
        }

        @Override
        public Iterator<LuceneDoc> iterator() {
            return MemorySavingConcatIterator.concat(this.fetchParentDocs(), this.fetchChildDocs());
        }

        private Iterator<LuceneDoc> fetchParentDocs() {
            log.debug("Will fetch parent docs {}", this.parentHandles);
            return this.partitionedFetch(this.parentHandles);
        }

        private Iterator<LuceneDoc> fetchChildDocs() {
            log.debug("Will fetch child docs {}", this.childHandles);
            final Collection parentIds = Collections2.transform(this.parentHandles, (Function)new Function<HibernateHandle, Long>(){

                public Long apply(HibernateHandle input) {
                    return input.getId();
                }
            });
            final boolean childrenScope = DefaultPageSearchHelper.SCOPE_CHILDREN.equals(this.scope);
            return Iterators.filter(this.partitionedFetch(this.childHandles), (Predicate)new Predicate<LuceneDoc>(){

                public boolean apply(LuceneDoc luceneDoc) {
                    return !childrenScope || DefaultPageSearchHelper.isChild(luceneDoc, parentIds);
                }
            });
        }

        Iterator<LuceneDoc> partitionedFetch(Iterable<HibernateHandle> handles) {
            return DefaultPageSearchHelper.this.fetchDocs((Iterable<HibernateHandle>)handles, 100);
        }
    }
}

