/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.util;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.contributors.search.lucene.BaseCollector;
import com.atlassian.confluence.contributors.util.AuthorRanking;
import com.atlassian.confluence.contributors.util.AuthorRankingSystem;
import com.atlassian.confluence.contributors.util.LuceneDoc;
import com.atlassian.confluence.contributors.util.PageDetailsHelper;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Effect;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageDetailsHelper
implements PageDetailsHelper {
    private static final Logger logger = LoggerFactory.getLogger(PageDetailsHelper.class);
    private static final String GLOBAL_LABEL_PREFIX = Namespace.GLOBAL.getPrefix() + ":";
    private static final String ANONYMOUS_USER = "Anonymous";
    private final ILuceneConnection luceneConnection;
    private final UserAccessor userAccessor;

    public DefaultPageDetailsHelper(ILuceneConnection luceneConnection, UserAccessor userAccessor) {
        this.luceneConnection = luceneConnection;
        this.userAccessor = userAccessor;
    }

    @Override
    public AuthorRankingSystem processDocumentList(Iterable<LuceneDoc> documents, AuthorRankingSystem.RankType rankType, PageDetailsHelper.GroupBy groupBy) {
        return this.processDocumentList(documents, rankType, groupBy, true, true, true, true);
    }

    @Override
    public AuthorRankingSystem processDocumentList(Iterable<LuceneDoc> luceneDocs, AuthorRankingSystem.RankType rankType, PageDetailsHelper.GroupBy groupBy, boolean includeContributors, boolean includeComments, boolean includeLabels, boolean includeWatches) {
        AuthorRankingSystem rankingSystem = new AuthorRankingSystem(rankType);
        Iterator<LuceneDoc> docIter = luceneDocs.iterator();
        if (!docIter.hasNext()) {
            return rankingSystem;
        }
        while (docIter.hasNext()) {
            LuceneDoc luceneDoc = docIter.next();
            if (includeContributors) {
                this.processAuthors(luceneDoc, rankingSystem, groupBy);
            }
            if (includeLabels) {
                this.processLabels(luceneDoc, rankingSystem, groupBy);
            }
            if (!includeWatches) continue;
            this.processPageWatches(luceneDoc, rankingSystem, groupBy);
        }
        if (includeWatches) {
            this.processSpaceWatches(rankingSystem, groupBy, (Filter)DefaultPageDetailsHelper.spaceKeysFilter(luceneDocs), DefaultPageDetailsHelper.docsBySpace(luceneDocs));
        }
        if (includeComments) {
            this.processComments(rankingSystem, groupBy, (Filter)DefaultPageDetailsHelper.filterByPageIds(luceneDocs));
        }
        return rankingSystem;
    }

    private void processAuthors(final LuceneDoc document, final AuthorRankingSystem rankingSystem, final PageDetailsHelper.GroupBy groupingType) {
        DefaultPageDetailsHelper.readDocumentField(document.getAuthorContributions(), "Error collecting information to calculate edit contributions of " + document.getTitle(), new Effect<String>(){

            public void apply(String line) {
                DefaultPageDetailsHelper.this.processAuthor(rankingSystem, groupingType, document.getTitle(), document.getUrlPath(), line);
            }
        });
    }

    private void processAuthor(AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType, String title, String url, String line) {
        Object[] authorContributionTokens = StringUtils.splitByWholeSeparator((String)line, (String)"<>");
        if (authorContributionTokens.length == 2 && !ArrayUtils.contains((Object[])authorContributionTokens, (Object)"")) {
            String authorFullName;
            long lastModifiedTime = Long.parseLong((String)authorContributionTokens[1]);
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(StringEscapeUtils.unescapeHtml4((String)authorContributionTokens[0])));
            String authorName = null == author ? ANONYMOUS_USER : author.getName();
            String string = authorFullName = null == author ? ANONYMOUS_USER : author.getFullName();
            if (groupingType == PageDetailsHelper.GroupBy.CONTRIBUTORS) {
                AuthorRanking ranking = rankingSystem.getAuthorRanking(authorName);
                if (ranking == null) {
                    ranking = rankingSystem.createAuthorRanking(authorName, authorFullName, lastModifiedTime);
                }
                ranking.incrementEdits(url, title, lastModifiedTime);
            } else if (groupingType == PageDetailsHelper.GroupBy.PAGES) {
                AuthorRanking ranking = rankingSystem.getAuthorRanking(url);
                if (ranking == null) {
                    ranking = rankingSystem.createAuthorRanking(url, title);
                }
                ranking.incrementEdits(authorName, authorFullName, lastModifiedTime);
            }
        }
    }

    private void processComments(final AuthorRankingSystem rankingSystem, final PageDetailsHelper.GroupBy groupBy, Filter filter) {
        TermQuery queryForComments = new TermQuery(new Term("type", "comment"));
        this.luceneConnection.withSearch(indexSearcher -> indexSearcher.search((Query)queryForComments, filter, (Collector)new BaseCollector(){

            public void collect(int doc) throws IOException {
                DefaultPageDetailsHelper.this.processComments(new LuceneDoc(indexSearcher.doc(this.docBase + doc)), rankingSystem, groupBy);
            }
        }));
    }

    private void processComments(LuceneDoc document, AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType) {
        AuthorRanking ranking;
        long lastModifiedTime = LuceneUtils.stringToDate((String)document.getModified()).getTime();
        String url = document.getUrlPath();
        String pageUrl = document.getPageUrlPath();
        String pageTitle = document.getPageDisplayTitle();
        String authorName = ANONYMOUS_USER;
        String authorFullName = ANONYMOUS_USER;
        String lastModifierName = document.getLastModifierName();
        if (!Strings.isNullOrEmpty((String)lastModifierName)) {
            ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(lastModifierName));
            authorName = author.getName();
            authorFullName = author.getFullName();
        }
        if (groupingType == PageDetailsHelper.GroupBy.CONTRIBUTORS) {
            ranking = rankingSystem.getAuthorRanking(authorName);
            if (ranking == null) {
                ranking = rankingSystem.createAuthorRanking(authorName, authorFullName);
            }
            ranking.incrementComments(pageUrl, pageTitle, lastModifiedTime);
        } else if (groupingType == PageDetailsHelper.GroupBy.PAGES) {
            ranking = rankingSystem.getAuthorRanking(pageUrl);
            if (ranking == null) {
                ranking = rankingSystem.createAuthorRanking(url, pageTitle);
            }
            ranking.incrementComments(authorName, authorFullName, lastModifiedTime);
        }
    }

    private void processLabels(final LuceneDoc document, final AuthorRankingSystem rankingSystem, final PageDetailsHelper.GroupBy groupingType) {
        DefaultPageDetailsHelper.readDocumentField(document.getLabelContributions(), "Error collecting information to calculate label contributions of " + document.getTitle(), new Effect<String>(){

            public void apply(String line) {
                DefaultPageDetailsHelper.this.processLabel(rankingSystem, groupingType, document.getTitle(), document.getUrlPath(), line);
            }
        });
    }

    private void processLabel(AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType, String title, String url, String line) {
        Object[] labelContributionTokens = StringUtils.splitByWholeSeparator((String)line, (String)"<>");
        if (labelContributionTokens.length == 3 && !ArrayUtils.contains((Object[])labelContributionTokens, (Object)"")) {
            String labelStr = StringEscapeUtils.unescapeHtml4((String)labelContributionTokens[0]);
            ParsedLabelName parsedLabel = LabelParser.parse((String)(labelStr.startsWith(GLOBAL_LABEL_PREFIX) ? labelStr.substring(GLOBAL_LABEL_PREFIX.length()) : labelStr));
            if (parsedLabel == null) {
                return;
            }
            long lastModifiedTime = Long.parseLong((String)labelContributionTokens[1]);
            String authorName = ANONYMOUS_USER;
            String authorFullName = ANONYMOUS_USER;
            Object contributor = labelContributionTokens[2];
            if (!Strings.isNullOrEmpty((String)contributor)) {
                ConfluenceUser author = this.userAccessor.getUserByKey(new UserKey(StringEscapeUtils.unescapeHtml4((String)contributor)));
                authorName = author.getName();
                authorFullName = author.getFullName();
            }
            String authorId = null;
            String fullName = null;
            String labelId = null;
            String labelDesc = null;
            if (groupingType == PageDetailsHelper.GroupBy.CONTRIBUTORS) {
                authorId = authorName;
                fullName = authorFullName;
                labelId = url;
                labelDesc = title;
            } else if (groupingType == PageDetailsHelper.GroupBy.PAGES) {
                authorId = url;
                fullName = title;
                labelId = authorName;
                labelDesc = authorFullName;
            }
            AuthorRanking ranking = rankingSystem.getAuthorRanking(authorId);
            if (ranking == null) {
                ranking = rankingSystem.createAuthorRanking(authorId, fullName);
            }
            ranking.incrementLabels(labelId, labelDesc, lastModifiedTime);
            ranking.addLabel(parsedLabel.toLabel().toString());
        }
    }

    private void processPageWatches(LuceneDoc document, AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType) {
        DefaultPageDetailsHelper.readDocumentField(document.getWatchers(), "Error collecting information to calculate watches contributions of " + document.getTitle(), (Effect<String>)((Effect)line -> {
            if (StringUtils.isNotBlank((CharSequence)line)) {
                this.processWatcher(rankingSystem, groupingType, document.getTitle(), document.getUrlPath(), (String)line);
            }
        }));
    }

    private void processSpaceWatches(final AuthorRankingSystem rankingSystem, final PageDetailsHelper.GroupBy groupingType, Filter filterBySpaceKeys, final Function<String, Iterable<LuceneDoc>> docsBySpace) {
        TermQuery queryForSpaces = new TermQuery(new Term("type", "space"));
        this.luceneConnection.withSearch(indexSearcher -> indexSearcher.search((Query)queryForSpaces, filterBySpaceKeys, (Collector)new BaseCollector(){

            public void collect(int doc) throws IOException {
                LuceneDoc spaceDocument = new LuceneDoc(indexSearcher.doc(this.docBase + doc));
                String spaceKey = spaceDocument.getKey();
                Iterable documents = (Iterable)docsBySpace.apply((Object)spaceKey);
                Set spaceWatchers = DefaultPageDetailsHelper.getSpaceWatchers(spaceDocument);
                for (LuceneDoc document : documents) {
                    DefaultPageDetailsHelper.this.processWatches(spaceWatchers, document, rankingSystem, groupingType);
                }
            }
        }));
    }

    private void processWatches(Set<String> spaceWatchers, LuceneDoc document, AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType) {
        for (String spaceWatcher : spaceWatchers) {
            this.processWatcher(rankingSystem, groupingType, document.getTitle(), document.getUrlPath(), spaceWatcher);
        }
    }

    private void processWatcher(AuthorRankingSystem rankingSystem, PageDetailsHelper.GroupBy groupingType, String title, String url, String line) {
        String authorFullName;
        ConfluenceUser watcher = this.userAccessor.getUserByKey(new UserKey(line));
        String authorName = null == watcher ? ANONYMOUS_USER : watcher.getName();
        String string = authorFullName = null == watcher ? ANONYMOUS_USER : watcher.getFullName();
        if (groupingType == PageDetailsHelper.GroupBy.CONTRIBUTORS) {
            AuthorRanking ranking = rankingSystem.getAuthorRanking(authorName);
            if (ranking == null) {
                ranking = rankingSystem.createAuthorRanking(authorName, authorFullName);
            }
            ranking.incrementWatches(url, title);
        } else if (groupingType == PageDetailsHelper.GroupBy.PAGES) {
            AuthorRanking ranking = rankingSystem.getAuthorRanking(url);
            if (ranking == null) {
                ranking = rankingSystem.createAuthorRanking(url, title);
            }
            ranking.incrementWatches(authorName, authorFullName);
        }
    }

    private static Function<String, Iterable<LuceneDoc>> docsBySpace(Iterable<LuceneDoc> luceneDocs) {
        return spaceKey -> Iterables.filter((Iterable)luceneDocs, input -> spaceKey.equals(input.getSpaceKey()));
    }

    private static Set<Long> extractPageIds(Iterable<LuceneDoc> documents) {
        HashSet ids = Sets.newHashSet();
        for (LuceneDoc document : documents) {
            String handleString = document.getHandle();
            try {
                ids.add(new HibernateHandle(handleString).getId());
            }
            catch (ParseException e) {
                return null;
            }
        }
        return ids;
    }

    private static TermsFilter filterByPageIds(Iterable<LuceneDoc> documents) {
        ArrayList pageDocumentTerms = Lists.newArrayList();
        Set<Long> pageDocumentIds = DefaultPageDetailsHelper.extractPageIds(documents);
        if (pageDocumentIds != null) {
            for (Long id : pageDocumentIds) {
                pageDocumentTerms.add(new Term("containingPageId", id.toString()));
            }
        }
        return new TermsFilter((List)pageDocumentTerms);
    }

    @VisibleForTesting
    static void readDocumentField(String[] fieldValues, String logErrorMessage, Effect<String> effect) {
        try {
            for (String fieldValue : fieldValues) {
                try (BufferedReader reader = new BufferedReader(new StringReader(StringUtils.defaultString((String)fieldValue)));){
                    String line;
                    while (null != (line = reader.readLine())) {
                        effect.apply((Object)line);
                    }
                }
            }
        }
        catch (IOException ioe) {
            logger.error(logErrorMessage, (Throwable)ioe);
        }
    }

    private static TermsFilter spaceKeysFilter(Iterable<LuceneDoc> luceneDocs) {
        HashSet spaceKeys = Sets.newHashSet((Iterable)Iterables.transform(luceneDocs, (Function)new Function<LuceneDoc, String>(){

            public String apply(LuceneDoc input) {
                return input.getSpaceKey();
            }
        }));
        return new TermsFilter((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)spaceKeys, (Function)new Function<String, Term>(){

            public Term apply(String spaceKey) {
                return new Term("key", spaceKey);
            }
        })));
    }

    private static Set<String> getSpaceWatchers(LuceneDoc document) {
        final HashSet watchers = Sets.newHashSet();
        DefaultPageDetailsHelper.readDocumentField(document.getWatchers(), "Error collecting space watchers.", new Effect<String>(){

            public void apply(String line) {
                if (StringUtils.isNotBlank((CharSequence)line)) {
                    watchers.add(line);
                }
            }
        });
        return watchers;
    }
}

