/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.search.extractors;

import com.atlassian.confluence.contributors.search.extractors.AbstractContributionExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

public class CommentContributionExtractor
extends AbstractContributionExtractor {
    public static final String CONTAINING_PAGE_ID = "containingPageId";

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        AbstractPage page;
        if (!(searchable instanceof Comment)) {
            return null;
        }
        try {
            ContentEntityObject owner = ((Comment)searchable).getOwner();
            if (!(owner instanceof AbstractPage)) {
                return null;
            }
            page = (AbstractPage)owner;
        }
        catch (IllegalStateException ise) {
            return null;
        }
        return ImmutableList.of((Object)new FieldDescriptor(CONTAINING_PAGE_ID, page.getIdAsString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
    }
}

