/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.search.extractors;

import com.atlassian.confluence.contributors.search.extractors.AbstractContributionExtractor;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorContributionExtractor
extends AbstractContributionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AuthorContributionExtractor.class);
    private ContentEntityObjectDao contentEntityObjectDao;

    public void setContentEntityObjectDao(ContentEntityObjectDao contentEntityObjectDao) {
        this.contentEntityObjectDao = contentEntityObjectDao;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        if (!(searchable instanceof AbstractPage)) {
            return null;
        }
        AbstractPage abstractPage = (AbstractPage)searchable;
        List versionHistories = this.contentEntityObjectDao.getVersionHistorySummary(abstractPage.getId());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (VersionHistorySummary versionHistory : versionHistories) {
            if (versionHistory.getLastModificationDate() == null) {
                logger.warn("Page#{} version#{} has a null last modification date and will be dropped from the content edit contribution calculation.", (Object)abstractPage.getId(), (Object)versionHistory.getVersion());
                continue;
            }
            ConfluenceUser lastModifier = versionHistory.getLastModifier();
            String key = StringEscapeUtils.escapeHtml(lastModifier == null ? null : lastModifier.getKey().getStringValue());
            long time = versionHistory.getLastModificationDate().getTime();
            String encoded = key + "<>" + time;
            builder.add((Object)new FieldDescriptor("authorContributions", encoded, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return builder.build();
    }
}

