/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.contributors.macro.BaseContributionMacro;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.contributors.util.AuthorRanking;
import com.atlassian.confluence.contributors.util.AuthorRankingSystem;
import com.atlassian.confluence.contributors.util.LuceneDoc;
import com.atlassian.confluence.contributors.util.PageDetailsHelper;
import com.atlassian.confluence.contributors.util.PageSearchHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ContributorsSummaryMacro
extends BaseContributionMacro {
    private static final String PARAMETER_COLUMNS = "columns";
    private static final String PARAMETER_GROUPBY = "groupby";
    private static final String PARAMETER_SHOWZEROCOUNTS = "showZeroCounts";
    private static final String GROUPBY_PAGE = "pages";
    private static final String COLUMNS_EDITS = "edits";
    private static final int COLUMNID_EDITS = 2;
    private static final String COLUMNS_EDITED = "edited";
    private static final int COLUMNID_EDITED = 3;
    private static final String COLUMNS_COMMENTS = "comments";
    private static final int COLUMNID_COMMENTS = 4;
    private static final String COLUMNS_COMMENTED = "commented";
    private static final int COLUMNID_COMMENTED = 5;
    private static final String COLUMNS_LABELS = "labels";
    private static final String DEFAULT_COLUMNS_PARAMETER_VALUE = StringUtils.join(Arrays.asList("edits", "comments", "labels"), (String)",");
    private static final int COLUMNID_LABELS = 6;
    private static final String COLUMNS_LABELED = "labeled";
    private static final int COLUMNID_LABLED = 7;
    private static final String COLUMNS_LABELSLIST = "labellist";
    private static final int COLUMNID_LABELSLIST = 8;
    private static final String COLUMNS_WATCHES = "watches";
    private static final int COLUMNID_WATCHES = 9;
    private static final String COLUMNS_WATCHING = "watching";
    private static final int COLUMNID_WATCHING = 10;
    private static final String COLUMNS_LASTUPDATE = "lastupdate";
    private static final int COLUMNID_LASTUPDATE = 32;
    private static final Set<String> COLUMNS = ImmutableSet.of((Object)"edits", (Object)"edited", (Object)"comments", (Object)"commented", (Object)"labels", (Object)"labeled", (Object[])new String[]{"labellist", "watches", "watching", "lastupdate"});
    private static final Predicate<String> IS_VALID_COLUMN_NAME = Predicates.in(COLUMNS);
    private static final Map<String, Integer> COLUMN_NAMES_TO_ID_MAP = ImmutableMap.builder().put((Object)"edits", (Object)2).put((Object)"edited", (Object)3).put((Object)"comments", (Object)4).put((Object)"commented", (Object)5).put((Object)"labels", (Object)6).put((Object)"labeled", (Object)7).put((Object)"labellist", (Object)8).put((Object)"watches", (Object)9).put((Object)"watching", (Object)10).put((Object)"lastupdate", (Object)32).build();
    private static final Function<String, Integer> COLUMN_NAME_TO_ID = Functions.forMap(COLUMN_NAMES_TO_ID_MAP);
    private static final Random TABLE_ID_GENERATOR = new Random();
    private final SettingsManager settingsManager;
    private final PageSearchHelper pageSearchHelper;
    private final PageDetailsHelper pageDetailsHelper;

    public ContributorsSummaryMacro(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, SettingsManager settingsManager, PageSearchHelper pageSearchHelper, PageDetailsHelper pageDetailsHelper) {
        super(localeManager, i18NBeanFactory);
        this.settingsManager = settingsManager;
        this.pageSearchHelper = pageSearchHelper;
        this.pageDetailsHelper = pageDetailsHelper;
    }

    public Streamable executeToStream(final Map<String, String> macroParameters, Streamable macroBody, ConversionContext conversionContext) throws MacroExecutionException {
        final ContentEntityObject contentObject = conversionContext.getEntity();
        if (contentObject instanceof AbstractPage) {
            return new Streamable(){

                public void writeTo(Writer writer) throws IOException {
                    ContributorsSummaryMacro.this.execute((Map<String, String>)macroParameters, (SpaceContentEntityObject)((AbstractPage)contentObject), writer);
                }
            };
        }
        if (contentObject instanceof Comment) {
            PageContext pageContext = ((Comment)contentObject).getOwner().toPageContext();
            return this.executeToStream(macroParameters, macroBody, (ConversionContext)new DefaultConversionContext((RenderContext)pageContext));
        }
        if (contentObject instanceof Draft) {
            return Streamables.from((String)RenderUtils.blockError((String)this.getText("error.preview", Arrays.asList(this.getText("com.atlassian.confluence.contributors.contributors-summary.label"))), (String)""));
        }
        return Streamables.from((String)RenderUtils.blockError((String)this.getText("error.unsupportedcontent", Arrays.asList(this.getText("com.atlassian.confluence.contributors.contributors-summary.label"))), (String)""));
    }

    private void execute(Map<String, String> macroParameters, SpaceContentEntityObject page, Appendable output) throws IOException {
        Collection<String> columnNames = ContributorsSummaryMacro.getColumnNames(macroParameters);
        Collection<Integer> columnIds = ContributorsSummaryMacro.getColumnIds(columnNames);
        PageDetailsHelper.GroupBy groupByType = ContributorsSummaryMacro.getGroupByType(macroParameters);
        this.appendTableHeader(columnIds, groupByType, output);
        MacroParameterModel parameterModel = new MacroParameterModel(macroParameters, page);
        Iterator<AuthorRanking> rankedAuthors = this.getRankedAuthors(macroParameters, columnNames, groupByType, parameterModel);
        this.appendTableBody(columnIds, groupByType, output, rankedAuthors, parameterModel);
        ContributorsSummaryMacro.appendTableFooter(output);
    }

    private static void appendTableFooter(Appendable outputBuilder) throws IOException {
        outputBuilder.append("</tbody></table>");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendTableBody(Iterable<Integer> columnIds, PageDetailsHelper.GroupBy groupByType, Appendable output, Iterator<AuthorRanking> authors, MacroParameterModel parameterModel) throws IOException {
        int limit = parameterModel.getLimit();
        String baseURL = this.settingsManager.getGlobalSettings().getBaseUrl();
        boolean showAnonymous = parameterModel.isShowAnonymousContributions();
        String linkPostfix = "</a> ";
        block16: for (int count = 0; authors.hasNext() && (count < limit || MacroParameterModel.isLimitLess(limit)); ++count) {
            AuthorRanking author = authors.next();
            String linkPrefix = "<a href=\"" + baseURL;
            output.append("<tr><td>");
            switch (groupByType) {
                case PAGES: {
                    output.append(linkPrefix).append(author.getIdString()).append("\">").append(author.getFullNameString()).append("</a> ");
                    linkPrefix = linkPrefix + "/display/~";
                    break;
                }
                case CONTRIBUTORS: {
                    if (ContributorsSummaryMacro.isAnonymous(author)) {
                        if (!showAnonymous) continue block16;
                        output.append("Anonymous");
                        break;
                    }
                    output.append(linkPrefix).append("/display/~").append(author.getIdString()).append("\">").append(HtmlUtil.htmlEncode((String)author.getFullNameString())).append("</a> ");
                }
            }
            output.append("</td>");
            for (int columnId : columnIds) {
                output.append("<td>");
                switch (columnId) {
                    case 4: {
                        output.append(String.valueOf(author.getComments()));
                        break;
                    }
                    case 5: {
                        for (Map.Entry entry : author.getCommentMap().entrySet()) {
                            ContributorsSummaryMacro.appendCellText(entry, linkPrefix, "</a> ", showAnonymous, output);
                        }
                        break;
                    }
                    case 2: {
                        output.append(String.valueOf(author.getEdits()));
                        break;
                    }
                    case 3: {
                        for (Map.Entry entry : author.getEditMap().entrySet()) {
                            ContributorsSummaryMacro.appendCellText(entry, linkPrefix, "</a> ", showAnonymous, output);
                        }
                        break;
                    }
                    case 6: {
                        output.append(String.valueOf(author.getLabels()));
                        break;
                    }
                    case 7: {
                        for (Map.Entry entry : author.getLabelMap().entrySet()) {
                            ContributorsSummaryMacro.appendCellText(entry, linkPrefix, "</a> ", showAnonymous, output);
                        }
                        break;
                    }
                    case 8: {
                        for (String string : author.getLabelList()) {
                            output.append("<a href=\"").append(baseURL).append("/label/").append(string).append("\">").append(string).append("</a> ");
                        }
                        break;
                    }
                    case 32: {
                        if (author.getLastActiveTime() <= 0L) break;
                        output.append(GeneralUtil.getRelativeTime((Date)author.getLastActiveDate()));
                        break;
                    }
                    case 9: {
                        output.append(String.valueOf(author.getWatches()));
                        break;
                    }
                    case 10: {
                        for (Map.Entry entry : author.getWatchMap().entrySet()) {
                            ContributorsSummaryMacro.appendCellText(entry, linkPrefix, "</a> ", showAnonymous, output);
                        }
                        break;
                    }
                }
                output.append("</td>");
            }
            output.append("</tr>");
        }
    }

    private static boolean isAnonymous(AuthorRanking author) {
        return "Anonymous".equals(author.getIdString());
    }

    private Iterator<AuthorRanking> getRankedAuthors(Map<String, String> macroParameters, Collection<String> columnNames, PageDetailsHelper.GroupBy groupByType, MacroParameterModel parameterModel) {
        Iterable<LuceneDoc> documents = this.getDocuments(parameterModel);
        AuthorRankingSystem rankingSystem = this.pageDetailsHelper.processDocumentList(documents, parameterModel.getRankType(AuthorRankingSystem.RankType.EDIT_COUNT), groupByType);
        boolean startValue = BooleanUtils.toBoolean((String)macroParameters.get(PARAMETER_SHOWZEROCOUNTS));
        List<AuthorRanking> rankedAuthors = rankingSystem.getRankedAuthors(parameterModel.isReverse(), startValue || columnNames.contains(COLUMNS_EDITS) || columnNames.contains(COLUMNS_EDITED) || columnNames.contains(COLUMNS_LASTUPDATE), startValue || columnNames.contains(COLUMNS_COMMENTS) || columnNames.contains(COLUMNS_COMMENTED) || columnNames.contains(COLUMNS_LASTUPDATE), startValue || columnNames.contains(COLUMNS_LABELS) || columnNames.contains(COLUMNS_LABELED) || columnNames.contains(COLUMNS_LABELSLIST) || columnNames.contains(COLUMNS_LASTUPDATE), startValue || columnNames.contains(COLUMNS_WATCHES) || columnNames.contains(COLUMNS_WATCHING) || columnNames.contains(COLUMNS_LASTUPDATE));
        return rankedAuthors.iterator();
    }

    private Iterable<LuceneDoc> getDocuments(MacroParameterModel parameterModel) {
        return this.pageSearchHelper.getDocuments(parameterModel.getPageTitle(), parameterModel.getSpaceKey(), parameterModel.getLabelsString(), parameterModel.getScope(), parameterModel.getPublishedDate(), parameterModel.getContentType());
    }

    private static Collection<String> getColumnNames(Map<String, String> macroParameters) {
        String columnsParameter = StringUtils.defaultString((String)macroParameters.get(PARAMETER_COLUMNS), (String)DEFAULT_COLUMNS_PARAMETER_VALUE);
        LinkedHashSet columnNames = Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)columnsParameter, (String)",")));
        return Collections2.filter((Collection)columnNames, IS_VALID_COLUMN_NAME);
    }

    private static Collection<Integer> getColumnIds(Collection<String> columnNames) {
        return Collections2.transform(columnNames, COLUMN_NAME_TO_ID);
    }

    private static PageDetailsHelper.GroupBy getGroupByType(Map<String, String> macroParameters) {
        return GROUPBY_PAGE.equals(macroParameters.get(PARAMETER_GROUPBY)) ? PageDetailsHelper.GroupBy.PAGES : PageDetailsHelper.GroupBy.CONTRIBUTORS;
    }

    private void appendTableHeader(Iterable<Integer> columnIds, PageDetailsHelper.GroupBy groupByType, Appendable output) throws IOException {
        output.append("<table id='").append(this.generateTableId()).append("' summary='").append(this.getText("summary.table.summary")).append("' class='aui'><tbody><tr><th>").append(this.getText(PageDetailsHelper.GroupBy.PAGES == groupByType ? "summary.tableheader.page" : "summary.tableheader.user")).append("</th>");
        for (int columnId : columnIds) {
            output.append("<th>");
            switch (columnId) {
                case 4: {
                    output.append(this.getText("summary.tableheader.comments"));
                    break;
                }
                case 5: {
                    output.append(this.getText("summary.tableheader.commented"));
                    break;
                }
                case 2: {
                    output.append(this.getText("summary.tableheader.edits"));
                    break;
                }
                case 3: {
                    output.append(this.getText("summary.tableheader.edited"));
                    break;
                }
                case 6: {
                    output.append(this.getText("summary.tableheader.labels"));
                    break;
                }
                case 7: {
                    output.append(this.getText("summary.tableheader.labelled"));
                    break;
                }
                case 8: {
                    output.append(this.getText("summary.tableheader.labellist"));
                    break;
                }
                case 32: {
                    output.append(this.getText("summary.tableheader.lastupdate"));
                    break;
                }
                case 9: {
                    output.append(this.getText("summary.tableheader.watches"));
                    break;
                }
                case 10: {
                    output.append(this.getText("summary.tableheader.watching"));
                    break;
                }
            }
            output.append("</th>");
        }
        output.append("</tr>");
    }

    private static void appendCellText(Map.Entry<String, String> entry, String linkPrefix, String linkPostfix, boolean showAnonymous, Appendable output) throws IOException {
        if (entry.getValue().equals("Anonymous")) {
            if (showAnonymous) {
                output.append("Anonymous").append(" ");
            }
        } else {
            output.append(linkPrefix).append(entry.getKey()).append("\">").append(entry.getValue()).append(linkPostfix);
        }
    }

    protected String generateTableId() {
        return "contributors-summary-" + TABLE_ID_GENERATOR.nextInt(Integer.MAX_VALUE);
    }
}

