/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.macro;

import com.atlassian.confluence.contributors.analytics.ContributorsMacroMetricsEvent;
import com.atlassian.confluence.contributors.macro.ContributorsMacroHelper;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.contributors.util.PageDetailsHelper;
import com.atlassian.confluence.contributors.util.PageSearchHelper;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.fugue.Either;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="contributors")
public class ContributorsMacroResource {
    private final ContributorsMacroHelper macroHelper;
    private final PageManager pageManager;

    public ContributorsMacroResource(PageSearchHelper pageSearchHelper, PageDetailsHelper pageDetailsHelper, PageManager pageManager) {
        this.pageManager = pageManager;
        this.macroHelper = new ContributorsMacroHelper(pageDetailsHelper, pageSearchHelper);
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> getContributors(@Context UriInfo uriInfo, @QueryParam(value="contextEntityId") Integer contextEntityId) {
        ContributorsMacroMetricsEvent.Builder dummyMetrics = ContributorsMacroMetricsEvent.builder();
        Either<String, Map<String, Object>> results = this.macroHelper.getAuthorRankingsModel(dummyMetrics, this.parameterModel(uriInfo, contextEntityId));
        if (results.isLeft()) {
            return Collections.singletonMap("errorMessage", results.left().get());
        }
        return (Map)results.right().get();
    }

    private MacroParameterModel parameterModel(@Context UriInfo uriInfo, @QueryParam(value="contextEntityId") Integer contextEntityId) {
        Map parameterMap = Maps.transformValues((Map)uriInfo.getQueryParameters(), (Function)new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        SpaceContentEntityObject contextEntity = (SpaceContentEntityObject)Objects.requireNonNull(this.pageManager.getAbstractPage((long)contextEntityId.intValue()), "No page found by ID " + contextEntityId);
        return new MacroParameterModel(parameterMap, contextEntity);
    }
}

