/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.macro;

import com.atlassian.confluence.contributors.analytics.ContributorsMacroMetricsEvent;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.contributors.util.AuthorRanking;
import com.atlassian.confluence.contributors.util.AuthorRankingSystem;
import com.atlassian.confluence.contributors.util.PageDetailsHelper;
import com.atlassian.confluence.contributors.util.PageSearchHelper;
import com.atlassian.fugue.Either;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContributorsMacroHelper {
    private final PageDetailsHelper pageDetailsHelper;
    private final PageSearchHelper pageSearchHelper;

    public ContributorsMacroHelper(PageDetailsHelper pageDetailsHelper, PageSearchHelper pageSearchHelper) {
        this.pageDetailsHelper = pageDetailsHelper;
        this.pageSearchHelper = pageSearchHelper;
    }

    public Either<String, Map<String, Object>> getAuthorRankingsModel(ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel parameterModel) {
        List<AuthorRanking> authorRankings = this.getAuthorRankings(metrics, parameterModel);
        if (authorRankings.isEmpty()) {
            return Either.left((Object)parameterModel.getNoContributorsErrorMessage());
        }
        return Either.right(this.buildContributorsModel(authorRankings, metrics, parameterModel));
    }

    private List<AuthorRanking> getAuthorRankings(ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel parameterModel) {
        metrics.documentFetchStart();
        PageSearchHelper.Result documents = this.pageSearchHelper.getDocuments(parameterModel.getPageTitle(), parameterModel.getSpaceKey(), parameterModel.getLabelsString(), parameterModel.getScope(), parameterModel.getPublishedDate(), parameterModel.getContentType());
        metrics.documentFetchFinish(documents.size());
        Collection<MacroParameterModel.ContributorsMacroInclude> includes = parameterModel.getIncludeParams();
        metrics.userFetchStart(includes);
        AuthorRankingSystem rankingSystem = this.pageDetailsHelper.processDocumentList(documents, parameterModel.getRankType(AuthorRankingSystem.RankType.TOTAL_COUNT), PageDetailsHelper.GroupBy.CONTRIBUTORS, includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.AUTHORS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.COMMENTS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.LABELS), includes.contains((Object)MacroParameterModel.ContributorsMacroInclude.WATCHES));
        List<AuthorRanking> rankedAuthors = rankingSystem.getRankedAuthors(parameterModel.isReverse());
        if (!parameterModel.isShowAnonymousContributions()) {
            rankedAuthors.remove(rankingSystem.getAuthorRanking("Anonymous"));
        }
        metrics.userFetchFinish(rankedAuthors.size());
        return rankedAuthors;
    }

    private Map<String, Object> buildContributorsModel(List<AuthorRanking> authorRankings, ContributorsMacroMetricsEvent.Builder metrics, MacroParameterModel params) {
        List<Object> hiddenUsers;
        List<AuthorRanking> visibleUsers;
        metrics.buildTemplateModelStart();
        MacroParameterModel.LayoutStyle layoutStyle = params.getLayoutStyle();
        int limit = params.getLimit();
        if (!MacroParameterModel.isLimitLess(limit) && limit < authorRankings.size()) {
            visibleUsers = authorRankings.subList(0, limit);
            hiddenUsers = authorRankings.subList(limit, authorRankings.size());
        } else {
            visibleUsers = authorRankings;
            hiddenUsers = Collections.emptyList();
        }
        ImmutableMap model = ImmutableMap.of((Object)"visibleContributors", visibleUsers, (Object)"hiddenContributors", hiddenUsers, (Object)"layoutStyle", (Object)layoutStyle.name(), (Object)"showCount", (Object)params.isShowCount(), (Object)"showTime", (Object)params.isShowTime());
        metrics.buildTemplateModelFinish(layoutStyle);
        return model;
    }
}

