/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.contributors.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.contributors.macro.BaseContributionMacro;
import com.atlassian.confluence.contributors.macro.ContributorsMacroClientSideRenderer;
import com.atlassian.confluence.contributors.macro.ContributorsMacroHelper;
import com.atlassian.confluence.contributors.macro.ContributorsMacroRenderer;
import com.atlassian.confluence.contributors.macro.ContributorsMacroServerSideRenderer;
import com.atlassian.confluence.contributors.macro.MacroParameterModel;
import com.atlassian.confluence.contributors.util.PageDetailsHelper;
import com.atlassian.confluence.contributors.util.PageSearchHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

public class ContributorsMacro
extends BaseContributionMacro {
    private final PageBuilderService pageBuilderService;
    private final TemplateRenderer templateRenderer;
    private final EventPublisher eventPublisher;
    private final ContributorsMacroHelper macroHelper;

    public ContributorsMacro(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PageSearchHelper pageSearchHelper, PageDetailsHelper pageDetailsHelper, PageBuilderService pageBuilderService, TemplateRenderer templateRenderer, EventPublisher eventPublisher) {
        super(localeManager, i18NBeanFactory);
        this.pageBuilderService = pageBuilderService;
        this.templateRenderer = templateRenderer;
        this.eventPublisher = eventPublisher;
        this.macroHelper = new ContributorsMacroHelper(pageDetailsHelper, pageSearchHelper);
    }

    public Streamable executeToStream(Map<String, String> macroParameters, Streamable macroBody, ConversionContext conversionContext) throws MacroExecutionException {
        ContentEntityObject contentObject = conversionContext.getEntity();
        if (contentObject instanceof AbstractPage) {
            return this.execute(conversionContext, new MacroParameterModel(macroParameters, (SpaceContentEntityObject)contentObject));
        }
        if (contentObject instanceof Comment) {
            ContentEntityObject commentContainer = ((Comment)contentObject).getOwner();
            return this.execute(conversionContext, new MacroParameterModel(macroParameters, (SpaceContentEntityObject)commentContainer));
        }
        if (contentObject instanceof Draft) {
            return this.error("error.preview");
        }
        return this.error("error.unsupportedcontent");
    }

    private Streamable error(String errorKey) {
        return Streamables.from((String)RenderUtils.blockError((String)this.getText(errorKey, Arrays.asList(this.getText("com.atlassian.confluence.contributors.contributors.label"))), (String)""));
    }

    private Streamable execute(ConversionContext conversionContext, final MacroParameterModel macroParameterModel) {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.confluence.contributors:contributors-web-resources");
        final ContributorsMacroRenderer renderer = this.selectRenderer(conversionContext);
        return new Streamable(){

            public void writeTo(Writer writer) throws IOException {
                renderer.render(writer, macroParameterModel);
            }
        };
    }

    private ContributorsMacroRenderer selectRenderer(ConversionContext conversionContext) {
        return ConversionContextOutputType.DISPLAY.toString().equalsIgnoreCase(conversionContext.getOutputType()) ? new ContributorsMacroClientSideRenderer(this.templateRenderer) : new ContributorsMacroServerSideRenderer(this.templateRenderer, this.macroHelper, this.eventPublisher);
    }
}

