/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.viewfile.macro;

import com.atlassian.confluence.plugins.viewfile.macro.ViewFileMacroUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FilePlaceholderGeneratorServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String fileType = URLDecoder.decode((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("type"), (CharSequence)""), "UTF-8");
        String fileName = URLDecoder.decode((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("name"), (CharSequence)""), "UTF-8");
        String fileHeight = (String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("height"), (CharSequence)"");
        InputStream imageStream = null;
        ServletOutputStream outputStream = null;
        try {
            BufferedImage bufferedImage = ViewFileMacroUtils.getPlaceholderWithFileName(fileName, fileType, fileHeight);
            resp.setContentType("image/png");
            outputStream = resp.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(imageStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly(imageStream);
    }
}

