/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.extras.builders.UsersEntityBuilder;
import com.atlassian.confluence.user.extras.entities.UserCreateRequestEntity;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/users")
@Produces(value={"application/json", "application/xml"})
public class UsersResource {
    private final UsersEntityBuilder usersEntityBuilder;
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private static final String DEFAULT_MAX_RESULTS_QUERY = "50";

    public UsersResource(UsersEntityBuilder usersEntityBuilder, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.usersEntityBuilder = usersEntityBuilder;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
    }

    @GET
    public Response getUsers(@QueryParam(value="startIndex") int startIndex, @DefaultValue(value="50") @QueryParam(value="maxResults") int maxResults) {
        if (this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.ok((Object)this.usersEntityBuilder.getUsers(startIndex, maxResults)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    public Response createUser(UserCreateRequestEntity request) {
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String username = request.getUsername();
        String password = request.getPassword();
        DefaultUser user = new DefaultUser(username, request.getFullName(), request.getEmail());
        Credential unencrypted = Credential.unencrypted((String)(null != password ? password : username));
        this.userAccessor.createUser((User)user, unencrypted);
        this.userAccessor.addMembership(this.userAccessor.getNewUserDefaultGroupName(), username);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/create/domain")
    public Response createUsers(@QueryParam(value="usernames") String usernamesStr, @QueryParam(value="domain") String emailDomain) {
        String[] usernames;
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        HashMap result = Maps.newHashMap();
        ArrayList created = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        result.put("created", created);
        result.put("failed", failed);
        for (String username : usernames = usernamesStr.split(",")) {
            String email = username + "@" + emailDomain;
            DefaultUser user = new DefaultUser(username, username, email);
            try {
                this.userAccessor.createUser((User)user, Credential.unencrypted((String)username));
                this.userAccessor.addMembership(this.userAccessor.getNewUserDefaultGroupName(), username);
                created.add(username);
            }
            catch (Exception e) {
                failed.add(username);
            }
        }
        return Response.ok((Object)result).build();
    }
}

