/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.extras.builders;

import com.atlassian.confluence.user.extras.entities.UserEntity;
import com.atlassian.confluence.user.extras.entities.UsersEntity;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public class UsersEntityBuilder {
    public static final int DEFAULT_MAX_RESULTS = 50;
    private final CrowdService crowdService;

    public UsersEntityBuilder(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public UsersEntity getUsers(int startIndex, int maxResults) {
        Iterable users = this.crowdService.search((Query)QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).startingAt(startIndex).returningAtMost(maxResults));
        UsersEntity usersEntity = new UsersEntity();
        usersEntity.setUsers(Lists.newArrayList((Iterable)Iterables.transform((Iterable)users, user -> {
            UserEntity userEntity = new UserEntity();
            userEntity.setUsername(user.getName());
            userEntity.setActive(user.isActive());
            return userEntity;
        })));
        return usersEntity;
    }
}

