require([
    'jquery',
    'confluence-user-profile/avatar-picker/avatar-picker-dialog'
],
/**
 * @tainted AJS.I18n
 * @tainted AJS.Meta
 */
function(
    $,
    AvatarPickerDialog
) {
    "use strict";

    $(function() {
        var avatarPickerDialog;
        var userKey = AJS.Meta.get('remote-user-key');

        var updatePreviewWithUploadedImage = function(avatarPath) {
            $('.user-avatar-preview').attr('src', AJS.Meta.get('context-path') + avatarPath); // update main preview image
            $('.userLogo').attr('src', AJS.Meta.get('context-path') + avatarPath); // update icon in top left
            $('.aui-avatar-inner img').attr('src', AJS.Meta.get('context-path') + avatarPath); // update icon in top right
        };

        var showConfigureLogoDialog = function (e) {
            if (!avatarPickerDialog) {
                avatarPickerDialog = new AvatarPickerDialog({
                    onCrop: function(croppedDataURI) {

                        // send off the croppedDataURI to Java land...
                        $.ajax({
                            type:'POST',
                            dataType:"json",
                            contentType:"application/json",
                            data: JSON.stringify({
                                avatarDataURI: croppedDataURI
                            }),
                            url: AJS.Meta.get('context-path') + '/rest/user-profile/1.0/' + userKey + '/avatar/upload',
                            success: function(data) {
                                updatePreviewWithUploadedImage(data.avatarPath);
                                avatarPickerDialog.hide();
                            },
                            error:function (xhr) {
                                avatarPickerDialog.setMessage(AJS.I18n.getText('user.avatar.picker.upload.error'));
                            }
                        });
                    }
                });
            }
            avatarPickerDialog.show();
            e.preventDefault();
            return false;
        };

        $('#profile-avatar-button').click(function (e) {
            showConfigureLogoDialog(e);
            e.preventDefault();
        });
    });
});