define("confluence-user-profile/avatar-picker/drag-drop-file-target", [
    "jquery",
    "underscore"
],
/**
 * @tainted AJS.I18n
 */
function(
    $,
    _
) {
    "use strict";

    function DragDropFileTarget(el, opts) {
        return this.init.apply(this, arguments);
    }

    DragDropFileTarget.prototype.getDefaults = function() {
        return {
            activeDropTargetClass: 'active-drop-target',
            uploadPrompt: AJS.I18n.getText('sidebar.avatar.picker.drag.image'),
            clientFileHandler: null
        };
    };

    DragDropFileTarget.prototype.init = function(el, opts) {
        _.bindAll(this, 'onDragOver', 'onDragEnd', 'onDrop');

        this._$target = $(el);
        this.options = _.extend({}, this.getDefaults(), opts);

        this._$target.attr('data-upload-prompt', this.options.uploadPrompt);

        //bind drag & drop events
        this._$target.on('dragover', this.onDragOver);
        this._$target.on('dragleave', this.onDragEnd);
        this._$target.on('dragend', this.onDragEnd);
        this._$target.on('drop', this.onDrop);
    };

    DragDropFileTarget.prototype.onDragOver = function(e) {
        e.preventDefault();
        this._$target.addClass(this.options.activeDropTargetClass);
    };

    DragDropFileTarget.prototype.onDragEnd = function(e) {
        e.preventDefault();
        this._$target.removeClass(this.options.activeDropTargetClass);
    };

    DragDropFileTarget.prototype.onDrop = function(e) {
        e.preventDefault();
        e.originalEvent.preventDefault();

        this._$target.removeClass(this.options.activeDropTargetClass);

        if (this.options.clientFileHandler) {
            this.options.clientFileHandler.handleFiles(e.originalEvent.dataTransfer.files, e.originalEvent.target);
        }
    };

    return DragDropFileTarget;
});