/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ui.rest.service.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.legacyapi.service.content.SpaceLabelService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.I18NSupport;

public class LegacySpaceLabelServiceImpl
implements SpaceLabelService {
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final LabelManager labelManager;

    public LegacySpaceLabelServiceImpl(SpaceManager spaceManager, PermissionManager permissionManager, LabelManager labelManager) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.labelManager = labelManager;
    }

    public void removeLabel(String spaceKey, long labelId) throws IllegalArgumentException {
        Space space = this.spaceManager.getSpace(spaceKey);
        Label label = this.labelManager.getLabel(labelId);
        if (label != null) {
            if (!LabelPermissionSupport.userCanEditLabel((Label)label, (Labelable)space.getDescription(), (PermissionManager)this.permissionManager)) {
                throw new IllegalArgumentException(I18NSupport.getText((String)"you.cannot.remove.this.label"));
            }
            this.labelManager.removeLabel((ContentEntityObject)space.getDescription(), label);
        }
    }
}

