/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ui.rest.service.content;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.legacyapi.model.content.Label;
import com.atlassian.confluence.util.I18NSupport;
import com.atlassian.user.User;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LegacyLabelHelper {
    public static Iterable<Label> extractViewableLabels(AbstractLabelableEntityObject labelable, Collection<Label.Prefix> prefixes, User user) {
        List labels = new PermittedLabelView((Labelable)labelable, user, false).getLabels();
        return Iterables.transform((Iterable)Iterables.filter((Iterable)labels, input -> prefixes.contains(Label.Prefix.valueOf((String)input.getNamespace().getPrefix()))), input -> new Label(input.getNamespace().getPrefix(), input.getName(), String.valueOf(input.getId())));
    }

    public static String concatentateLabels(Iterable<Label> labels) {
        StringBuilder fullLabel = new StringBuilder();
        for (Label label : labels) {
            String prefix = StringUtils.isEmpty((CharSequence)label.getPrefix()) ? "" : label.getPrefix() + ":";
            fullLabel.append(prefix).append(label.getLabel()).append(" ");
        }
        return fullLabel.toString().trim();
    }

    public static void validateLabelsCommand(ServiceCommand command) throws IllegalArgumentException {
        if (!command.isValid()) {
            ValidationError error = (ValidationError)command.getValidationErrors().iterator().next();
            String errorMessage = I18NSupport.getText((String)error.getMessageKey(), (Object[])error.getArgs());
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

