define('confluence-templates/variable-marshaller', [
    'ajs',
    'jquery',
    'confluence/legacy'
], function(
    AJS,
    $,
    Confluence
) {
    var DEFAULT_ROWS = 5;
    var DEFAULT_COLUMNS = 100;

    function toVariable(li) {
        var type = li.attr('data-variable-type');
        if(type === "textarea") {
            return {
                type: type,
                rows: +li.attr('data-variable-rows') || DEFAULT_ROWS,
                columns: +li.attr('data-variable-columns') || DEFAULT_COLUMNS
            };
        } else if (type === "list") {
            return {
                type: type,
                options : li.find('li').map(function() { return $(this).attr('data-variable-option'); }).toArray()
            };
        }
        return {
            type: "string" // be explicit in case a bad / missing type
        };
    }

    function encodeVariable(name, details) {
        var optionsGroup;
        var optionLi;
        var type = details.type;
        var li = $('<li></li>');
        li.attr('data-variable-name', name);
        li.attr('data-variable-type', type);
        li.text(name);
        if(type === "textarea") {
            li.attr('data-variable-rows', details.rows);
            li.attr('data-variable-columns', details.columns);
        } else if (type === "list") {
            optionsGroup = $('<ul></ul>');
            for(var option in details.options) {
                var val = details.options[option];
                optionLi = $('<li></li>').text(val).attr('data-variable-option', val);
                optionsGroup.append(optionLi);
            }
            li.append(optionsGroup);
        }
        return li;
    }

    function getUsedVariables() {
        var usages = $(AJS.Rte.getEditor().getBody()).find('img[data-variable-name]');
        var used = {};
        $.map(usages, function(el) {
            var attrs = {};
            if ($(el).attr("data-variable-raw-xhtml")) {
                attrs = {"data-variable-raw-xhtml": true};
            }
            used[$(el).attr('data-variable-name')] = attrs;
        });
        return used;
    }

    return function() {

        var ed = AJS.Rte.getEditor();
        var edBody = $(ed.getBody());
        var dGroup;
        var dec;
        var varMgr = Confluence.VariableManager.defaultVariableManager;

        function addUndeclaredVariables(inUse) {
            for(var used in inUse) {
                if(inUse.hasOwnProperty(used)) {
                    if(!varMgr.contains(used)) {
                        AJS.debug('adding: ', used);
                        varMgr.add(used, inUse[used]);
                    }
                }
            }
        }

        ed.onGetContent.add(function(ed, o) {
            var variableDeclaration = $('<div></div>');
            var ul = $('<ul></ul>').attr('data-variable-declarations', 'true');
            var li;

            variableDeclaration.append(ul);

            var inUse = getUsedVariables();

            // Handle case of variables missing from variable manager (e.g. copy and paste)
            addUndeclaredVariables(inUse);

            var variables = varMgr.getAll();
            for(var variable in variables) {
                if(inUse.hasOwnProperty(variable)) {
                    li = encodeVariable(variable, variables[variable]);
                    ul.append(li);
                }
            }

            o.content = variableDeclaration.html() + o.content;
        });

        // Extract declared variables
        dGroup = edBody.find('ul[data-variable-declarations]');
        dGroup.remove();
        dec = dGroup.find('li[data-variable-name]');
        dec.each(function() {
            var el = $(this);
            varMgr.add(el.attr('data-variable-name'), toVariable(el));
        });
        // Cover case where there's undeclared variables (e.g. a blueprint missing some declarations)
        addUndeclaredVariables(getUsedVariables());
    };
});

if(AJS.Meta.get("content-type") === "template") {
    require('confluence/module-exporter').safeRequire('confluence-templates/variable-marshaller', function(VariableMarshaller) {
        require('ajs').bind("init.rte", VariableMarshaller);
    });
}
