define('confluence-templates/variable-manager', [
    'confluence/api/event',
    'jquery'
], function(
    event,
    $
) {
    function caseInsensitiveLocalCompare(a, b) {
        var la = a.toLocaleLowerCase();
        var lb = b.toLocaleLowerCase();
        var r = la.localeCompare(lb);
        if(r == 0) {
            r = a.localCompare(b);
        }
        return r;
    }

    function defaultVariable(type) {
        var defaultVar = VariableManager.defaults[type] || VariableManager.defaults["string"];
        return $.extend(true, {}, defaultVar);
    }

    var VariableManager = function() {
        var variables = {};

        return {
            find : function(startName) {
                var search = startName.toLocaleLowerCase();
                var result = {};
                for(var k in variables) {
                    if(variables.hasOwnProperty(k)) {
                        if(!search.length || k.toLocaleLowerCase().indexOf(search) === 0) {
                            result[k] = variables[k];
                        }
                    }
                }
                return result;
            },

            contains: function(name) {
                return !!variables[name];
            },

            get : function(name) {
                return variables[name];
            },

            getAll : function() {
                return $.extend(true, {}, variables); // clone a copy
            },

            getSortedNames : function() {
                var names = [];
                for(var name in variables) {
                    names.push(name);
                }
                return names.sort(caseInsensitiveLocalCompare);
            },

            add : function(name, details) {
                variables[name] = details || defaultVariable();
                event.trigger('add.confluence-variable', {
                    name: name,
                    details :$.extend(true, {}, details)
                });
            },

            del : function(name) {
                var details = variables[name];
                delete variables[name];
                event.trigger('delete.confluence-variable', {
                    name: name,
                    details :$.extend(true, {}, details)
                });
            },

            rename : function(oldName, newName) {
                var old = variables[oldName];
                delete variables[oldName];
                if(old) {
                    variables[newName] = old;
                    event.trigger('rename.confluence-variable', {
                        oldName: oldName,
                        newName: newName,
                        details :$.extend(true, {}, details)
                    });
                }
            },

            createDefault: defaultVariable
        };
    };

    VariableManager.defaultVariableManager = VariableManager();
    VariableManager.defaults =  {
        textarea: {
            type: "textarea",
            rows: 5,
            columns: 100
        },
        list: {
            type: "list",
            options: []
        },
        string: {
            type: "string"
        }
    };

    return VariableManager;
});

if(AJS.Meta.get("content-type") === "template") {
    require('confluence/module-exporter').safeRequire('confluence-templates/variable-manager', function(VariableManager) {
        require('confluence/legacy').VariableManager = VariableManager;
    });
}
