define('confluence-templates/property-panel-variables', [
    'ajs',
    'jquery',
    'confluence/legacy'
], function (
    AJS,
    $,
    Confluence
) {
    "use strict";

    return {
        name: "variable",

        canHandleElement: function ($element) {
            return $element.hasClass("template-variable");
        },

        handle: function (data) {
            if (data.e.type !== "click" && data.e.type !== "mouseup") { // only activate this panel on click
                return;
            }

            var variableNode = data.containerEl;
            var $variableNode = $(variableNode);

            var variableName;

            var buttons = [];
            var options = {
                originalHeight: $variableNode.height(),
                anchorIframe: AJS.Rte.getEditorFrame()
            };

            variableName = $variableNode.attr("data-variable-name");

            var variableManager = Confluence.VariableManager.defaultVariableManager;
            var variable = variableManager.get(variableName);
            var variableType = (variable && variable.type) || "string";

            function changeType(type) {
                variable = variableManager.createDefault(type);
                variableManager.add(variableName, variable);
                $('.variable-property-panel-type-item').removeClass('selected');
                $('.variable-property-panel-type-' + type).addClass('selected');
                refreshPanel(type);
            }

            function refreshPanel(type) {
                AJS.debug('clicked type: ' + type);
                var pp = $('#property-panel');

                pp.find('.panel-buttons').toggleClass('no-inputs', type === 'string');
                pp.find('.textarea-section,.list-section,.string-section').addClass('hidden');
                pp.find('.' + type + '-section').removeClass('hidden');
                if (type === "textarea") {
                    $('#variable-property-panel-textarea-rows').val(variable.rows);
                    $('#variable-property-panel-textarea-columns').val(variable.columns);
                } else if (type === "list") {
                    $('#variable-property-panel-list-values').val(variable.options.join(","));
                }
            }

            function createTypeButton(type, text, tooltip) {
                return {
                    className: "variable-property-panel-type-item variable-property-panel-type-" + type,
                    text: text,
                    tooltip: tooltip,
                    selected: variableType === type,
                    click: function () {
                        variable.type = type;
                        changeType(type);
                    }
                };
            }

            function typeHiddenClass(type) {
                return (variableType === type) ? "" : " hidden";
            }

            buttons.push(createTypeButton("string", AJS.I18n.getText("property.panel.variable.display.string"), AJS.I18n.getText("property.panel.variable.display.string.tooltip")));
            buttons.push(createTypeButton("textarea", AJS.I18n.getText("property.panel.variable.display.textarea"), AJS.I18n.getText("property.panel.variable.display.textarea.tooltip")));
            buttons.push(createTypeButton("list", AJS.I18n.getText("property.panel.variable.display.list"), AJS.I18n.getText("property.panel.variable.display.list.tooltip")));
            buttons.push(null);
            buttons.push({
                className: "editable textarea-section" + typeHiddenClass("textarea"),
                tooltip: AJS.I18n.getText("property.panel.variable.textarea.rows.tooltip"),
                html: "<input id=\"variable-property-panel-textarea-rows\"/>"
            });
            buttons.push({
                className: "variable-property-panel-textarea-split textarea-section" + typeHiddenClass("textarea"),
                tooltip: "",
                html: "<span>x</span>"
            });
            buttons.push({
                className: "editable textarea-section" + typeHiddenClass("textarea"),
                tooltip: AJS.I18n.getText("property.panel.variable.textarea.columns.tooltip"),
                html: "<input id=\"variable-property-panel-textarea-columns\"/>"
            });
            buttons.push(null);
            buttons.push({
                className: "editable list-section" + typeHiddenClass("list"),
                tooltip: AJS.I18n.getText("property.panel.variable.list.values.tooltip"),
                html: "<input id=\"variable-property-panel-list-values\" size='50'/>"
            });

            AJS.Confluence.PropertyPanel.createFromButtonModel("variable", variableNode, buttons, options);

            refreshPanel(variable.type);

            $('#variable-property-panel-textarea-rows').change(function () {
                variable.rows = +$(this).val() || Confluence.VariableManager.defaults.textarea.rows;
            });
            $('#variable-property-panel-textarea-columns').change(function () {
                variable.columns = +$(this).val() || Confluence.VariableManager.defaults.textarea.columns;
            });
            $('#variable-property-panel-list-values').change(function () {
                var i;
                var l;
                var v;
                var opts = $(this).val().split(',');
                variable.options = [];
                for (i = 0, l = opts.length; i < l; i++) {
                    // trim and filter empty values
                    v = $.trim(opts[i]);
                    v && variable.options.push(v);
                }
            });
            $('#variable-property-panel-textarea-rows,#variable-property-panel-textarea-columns,#variable-property-panel-list-values').keypress(function (e) {
                if (e.which === 13) {
                    $(this).blur();
                }
            });
        }

    };
});

require('confluence/module-exporter')
    .exportModuleAsGlobal('confluence-templates/property-panel-variables', 'AJS.Confluence.PropertyPanel.Variable', function(PropertyPanelVariable) {
        var AJS = require('ajs');

        AJS.bind("init.rte", function () {
            // defer trigger to ensure any listeners have had a chance to load.
            AJS.trigger("add-handler.property-panel", PropertyPanelVariable);
        });
    });
