define('confluence-templates/manage-templates', [
    'ajs',
    'document',
    'confluence/templates',
    'confluence/meta'
], function(
    AJS,
    document,
    Templates,
    Meta
) {
    "use strict";

    var ManageTemplates = {};

    ManageTemplates.init = function($) {
        $(document).on('click', 'a.remove-template', function(e) {
            e.preventDefault();
            var dialogId = "remove-dialog";
            var link = $(this);
            var templateName = link.attr('data-template-name');
            var removeUrl = link.attr('href');
            var popup = new AJS.Dialog({
                width: 450,
                height: 180,
                id: dialogId,
                closeOnOutsideClick: false
            });
            popup.addHeader(AJS.I18n.getText("remove.template.heading"));
            popup.addSubmit(AJS.I18n.getText("remove.template.confirm"), function() {
                popup.getCurrentPanel().body.find('form').submit();
            });
            popup.addCancel(AJS.I18n.getText("remove.template.cancel"), function() {
                popup.remove();
            });
            popup.addPanel("Panel 1", "panel1");
            popup.getCurrentPanel().html(Templates.Manage.removeDialogContent({
                atlToken : Meta.get('atl-token'),
                actionUrl : removeUrl,
                templateName : AJS.escapeHtml(templateName)
            }));
            popup.show();
        });

        $(document).on('click', '#pagetemplates-table .template-description a.editor-icon', function(e) {
            e.preventDefault();
            var link = $(this);
            var popup = new AJS.Dialog({
                width: 400,
                height: 260,
                id: "edit-pagetemplate-description-dialog",
                closeOnOutsideClick: false
            });
            popup.addHeader(AJS.I18n.getText("com.atlassian.confluence.plugins.confluence-templates.edit.description.dialog.title"));
            popup.addSubmit(AJS.I18n.getText("save.name"), function() {
                popup.getCurrentPanel().body.find('form').submit();
            });
            popup.addCancel(AJS.I18n.getText("cancel.name"), function() {
                popup.remove();
            });
            popup.addPanel("Panel 1", "panel1");
            popup.getCurrentPanel().html(Templates.Manage.editDescriptionDialogContent({
                atlToken : Meta.get('atl-token'),
                actionUrl : link.attr('href'),
                existingDescription : link.parent().find('.existing-description').text()
            }));
            // Make the dialog textarea's maxlength limit work even for browsers that don't support it (HTML5 only?)
            popup.getCurrentPanel().body.find('form textarea[maxlength]').bind('input propertychange', function() {
                var textarea = $(this);
                var maxLength = textarea.attr('maxlength');
                var currentValue = textarea.val();
                if (currentValue.length > maxLength) {
                    textarea.val(currentValue.substring(0, maxLength));
                }
            });
            popup.show();
        });
    };

    return ManageTemplates;
});

require('confluence/module-exporter').safeRequire('confluence-templates/manage-templates', function(ManageTemplates) {
    require('ajs').toInit(ManageTemplates.init);
});
