/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.team;

import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.links.SimpleLink;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.listeners.NotificationTemplate;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationRenderManager;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintHomePageCreateEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.core.util.PairType;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Maybe;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.util.collect.Predicate;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;

public class SpaceHomePageEventListener {
    private static final String EMAIL_RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-email-resources";
    private static final String TEAM_SPACE_EMAIL_RESOURCES = "team-space-email-resources";
    private static final String TEAM_SPACE_EMAIL_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-space-blueprints:team-space-email-resources";
    private static final String TEAM_SPACE_EMAIL_SOY_TEMPLATE = "Confluence.Templates.Team.Space.Notifications.teamSpaceEmail.soy";
    private static final String TEAM_SPACE_ICON_KEY = "team-space-icon";
    private static final String TEAM_SPACE_TYPE = "team-space";
    private List<DataSource> iconResources = Lists.newArrayList();
    private final UserAccessor userAccessor;
    private final NotificationManager notificationManager;
    private final DataSourceFactory dataSourceFactory;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final MultiQueueTaskManager taskManager;
    private final NotificationRenderManager notificationRenderManager;

    public SpaceHomePageEventListener(UserAccessor userAccessor, NotificationManager notificationManager, DataSourceFactory dataSourceFactory, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, MultiQueueTaskManager taskManager, NotificationRenderManager notificationRenderManager) {
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
        this.dataSourceFactory = dataSourceFactory;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.taskManager = taskManager;
        this.notificationRenderManager = notificationRenderManager;
    }

    @EventListener
    public void onSpaceHomePageCreate(SpaceBlueprintHomePageCreateEvent event) {
        if (!"com.atlassian.confluence.plugins.confluence-space-blueprints:team-space-blueprint".equals(event.getSpaceBlueprint().getModuleCompleteKey())) {
            return;
        }
        String members = (String)event.getContext().get("members");
        String description = (String)event.getContext().get("description");
        Space space = event.getSpace();
        String[] usernames = members.split(",");
        ArrayList users = Lists.newArrayList();
        for (String username : usernames) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (user == null) continue;
            this.notificationManager.addSpaceNotification((User)user, space);
            users.add(user);
        }
        ConfluenceUser creator = event.getCreator();
        if (NotificationTemplate.ADG.isEnabled("team.space")) {
            this.sendNotifications(creator, description, space, users);
        }
    }

    private void sendNotifications(ConfluenceUser creator, String description, Space space, List<ConfluenceUser> users) {
        ArrayList allTeamMembers = Lists.newArrayList();
        HashMap allAvatarHandlers = Maps.newHashMap();
        HashMap avatarUserMap = Maps.newHashMap();
        DataHandler avatarHandler = new DataHandler(this.dataSourceFactory.getAvatar((User)creator));
        allAvatarHandlers.put(avatarHandler.getName(), avatarHandler);
        avatarUserMap.put(creator, avatarHandler.getName());
        for (ConfluenceUser user : users) {
            avatarHandler = new DataHandler(this.dataSourceFactory.getAvatar((User)user));
            allAvatarHandlers.put(avatarHandler.getName(), avatarHandler);
            avatarUserMap.put(user, avatarHandler.getName());
            allTeamMembers.add(new PairType((Serializable)user, (Serializable)((Object)avatarHandler.getName())));
        }
        DataHandler senderAvatarDataHandler = new DataHandler(this.dataSourceFactory.getAvatar((User)creator));
        NotificationContext context = new NotificationContext();
        context.put("spaceName", (Object)space.getName());
        context.put("spaceUrl", (Object)space.getUrlPath());
        context.put("teamSpaceType", (Object)TEAM_SPACE_TYPE);
        context.put("sender", (Object)creator);
        context.put("contentSummary", (Object)description);
        context.put("avatarCid", (Object)senderAvatarDataHandler.getName());
        context.put("spaceKey", (Object)space.getKey());
        context.put("homePageUrl", (Object)space.getHomePage().getUrlPath());
        context.put("actionLinks", this.getWebItemLinks("email.adg.space.action.links", context));
        this.notificationRenderManager.attachActionIconImages("email.adg.space.action.links", context);
        this.populateIcons(context);
        for (ConfluenceUser user : users) {
            if (user.equals(creator)) continue;
            ArrayList teamMembers = Lists.newArrayList((Iterable)allTeamMembers);
            teamMembers.remove(new PairType((Serializable)user, (Serializable)avatarUserMap.get(user)));
            context.put("userList", (Object)teamMembers);
            HashMap teamAvatarHandlers = Maps.newHashMap((Map)allAvatarHandlers);
            teamAvatarHandlers.remove(avatarUserMap.get(user));
            this.sendTeamSpaceNotification(creator, user, this.convertToDataSource(teamAvatarHandlers), context);
        }
    }

    private List<SimpleLink> getWebItemLinks(String section, NotificationContext context) {
        List webItems = this.notificationRenderManager.getDisplayableItems(section, context);
        ArrayList emailLinks = Lists.newArrayList();
        for (WebItemModuleDescriptor webItem : webItems) {
            String url = webItem.getLink().getRenderedUrl(context.getMap());
            String i18nKey = webItem.getWebLabel().getKey();
            emailLinks.add(new SimpleLink(i18nKey, url));
        }
        return emailLinks;
    }

    private void sendTeamSpaceNotification(ConfluenceUser creator, ConfluenceUser receivingUser, List<DataSource> teamMemberAvatarHandlers, NotificationContext context) {
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)receivingUser));
        String subject = i18n.getText("confluence.blueprints.space.team.email.subject", (Object[])new String[]{creator.getFullName()});
        this.taskManager.addTask("mail", (Task)this.createNotificationTask(creator, receivingUser, subject, context, teamMemberAvatarHandlers));
    }

    private MailQueueItem createNotificationTask(ConfluenceUser creator, ConfluenceUser receiver, String subject, NotificationContext context, List<DataSource> avatarHandlers) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)receiver, (String)TEAM_SPACE_EMAIL_SOY_TEMPLATE, (String)subject).andSender((User)creator).andTemplateLocation(TEAM_SPACE_EMAIL_COMPLETE_KEY).andContext(context.getMap()).andRelatedBodyParts(avatarHandlers).andRelatedBodyParts(this.iconResources).andRelatedBodyParts((Iterable)this.imagesUsedByChromeTemplate().get());
        return builder.render();
    }

    private void populateIcons(NotificationContext context) {
        this.iconResources.add((DataSource)((PluginDataSourceFactory)this.dataSourceFactory.forPlugin("com.atlassian.confluence.plugins.confluence-space-blueprints").get()).resourceFromModuleByName(TEAM_SPACE_EMAIL_RESOURCES, TEAM_SPACE_ICON_KEY).get());
        this.iconResources.addAll(context.getTemplateImageDataSources());
    }

    private List<DataSource> convertToDataSource(Map<String, DataHandler> avatarDataHandlers) {
        return Lists.newArrayList((Iterable)Iterables.transform(avatarDataHandlers.values(), (Function)new Function<DataHandler, DataSource>(){

            public DataSource apply(DataHandler input) {
                return input.getDataSource();
            }
        }));
    }

    private Maybe<Iterable<DataSource>> imagesUsedByChromeTemplate() {
        return ((PluginDataSourceFactory)this.dataSourceFactory.forPlugin(EMAIL_RESOURCE_KEY).get()).resourcesFromModules("chrome-template", (Predicate)PluginDataSourceFactory.FilterByType.IMAGE);
    }
}

