/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.documentation;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintCreateEvent;
import com.atlassian.confluence.plugins.ia.SidebarLinkCategory;
import com.atlassian.confluence.plugins.ia.rest.SidebarLinkBean;
import com.atlassian.confluence.plugins.ia.service.SidebarLinkService;
import com.atlassian.confluence.plugins.ia.service.SidebarService;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.user.User;
import java.util.Map;

public class CreateSpaceEventListener {
    private final SidebarService sidebarService;
    private final SidebarLinkService sidebarLinkService;
    private I18NBeanFactory i18NBeanFactory;
    private LocaleManager localeManager;
    private static final String DOCUMENTATION_SPACE_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-space-blueprints:documentation-space-blueprint";

    public CreateSpaceEventListener(SidebarService sidebarService, SidebarLinkService sidebarLinkService, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.sidebarService = sidebarService;
        this.sidebarLinkService = sidebarLinkService;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    @EventListener
    public void onSpaceBlueprintCreate(SpaceBlueprintCreateEvent event) throws NotPermittedException {
        if (!event.getSpaceBlueprint().getModuleCompleteKey().equals(DOCUMENTATION_SPACE_COMPLETE_KEY)) {
            return;
        }
        Map context = event.getContext();
        Space space = event.getSpace();
        context.put("spaceKey", space.getKey());
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
        String pageTitle = i18NBean.getText("confluence.blueprints.space.documentation.making-a-template.name");
        context.put("makingATemplateLink", "<ri:page ri:content-title=\"" + pageTitle + "\" />");
        String spaceKey = space.getKey();
        this.sidebarService.setOption(spaceKey, "nav-type", "page-tree");
        this.sidebarService.setOption(spaceKey, "quick-links-state", "hide");
        for (SidebarLinkBean link : this.sidebarLinkService.getLinksForSpace(SidebarLinkCategory.MAIN, spaceKey, false)) {
            this.sidebarLinkService.hide(spaceKey, Integer.valueOf(link.getId()));
        }
    }
}

