/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.soy;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.InputStreamSerializer;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.fugue.Maybe;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.activation.DataSource;

public class ImportResourceFunction
implements SoyServerFunction<String> {
    private static final ImmutableSet<Integer> VALID_ARGUMENT_SIZES = ImmutableSet.of((Object)2);
    private final DataSourceFactory dataSourceFactory;

    public ImportResourceFunction(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public String getName() {
        return "importResource";
    }

    public String apply(Object ... args) {
        ModuleCompleteKey moduleCompleteKey = new ModuleCompleteKey((String)args[0]);
        String resourceName = (String)args[1];
        Maybe maybePlugin = this.dataSourceFactory.forPlugin(moduleCompleteKey.getPluginKey());
        if (maybePlugin.isEmpty() && !ConfluenceSystemProperties.isDevMode()) {
            return "";
        }
        Maybe maybeResource = ((PluginDataSourceFactory)maybePlugin.get()).resourceFromModuleByName(moduleCompleteKey.getModuleKey(), resourceName);
        if (maybeResource.isEmpty() && !ConfluenceSystemProperties.isDevMode()) {
            return "";
        }
        return InputStreamSerializer.eagerInDevMode().addDataSource(new DataSource[]{(DataSource)maybeResource.get()}).toString();
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARGUMENT_SIZES;
    }
}

