/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.soy;

import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.renderer.template.TemplateRenderingException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collections;
import java.util.Map;

public class ConfluenceSoyTemplateRenderer
implements TemplateRenderer {
    private final SoyTemplateRenderer delegate;

    public ConfluenceSoyTemplateRenderer(SoyTemplateRenderer delegate) {
        this.delegate = delegate;
    }

    public void renderTo(Appendable appendable, String templateProviderPluginKey, String templateName, Map<String, Object> data) throws TemplateRenderingException {
        this.renderTo(appendable, templateProviderPluginKey, templateName, data, Collections.emptyMap());
    }

    public Streamable render(String templateProviderPluginKey, String templateName, Map<String, Object> data) throws TemplateRenderingException {
        return writer -> this.renderTo(writer, templateProviderPluginKey, templateName, data);
    }

    public void renderTo(Appendable appendable, String templateProviderPluginKey, String templateName, Map<String, Object> data, Map<String, Object> injectedData) throws TemplateRenderingException {
        String profileName = UtilTimerStack.isActive() ? "Rendering soy template: " + templateProviderPluginKey + ":" + templateName : null;
        UtilTimerStack.push(profileName);
        templateName = ConfluenceSoyTemplateRenderer.removeSuffix(templateName);
        try {
            this.delegate.render(appendable, templateProviderPluginKey, templateName, data, injectedData);
        }
        catch (SoyException e) {
            throw new TemplateRenderingException(e.getMessage(), (Throwable)e);
        }
        finally {
            UtilTimerStack.pop((String)profileName);
        }
    }

    public Streamable render(String templateProviderPluginKey, String templateName, Map<String, Object> data, Map<String, Object> injectedData) throws TemplateRenderingException {
        return writer -> this.renderTo(writer, templateProviderPluginKey, templateName, data, injectedData);
    }

    private static String removeSuffix(String templateName) {
        if (templateName.length() > 4 && templateName.endsWith(".soy")) {
            return templateName.substring(0, templateName.length() - 4);
        }
        return templateName;
    }
}

