(function ($) {

    function bindJiraSelector(e, state) {
        var selectionContainer = $('#jirareports-select-type');
        var templates = selectionContainer.find('.template');

        if (Confluence.Blueprints.JiraReport.servers.length === 0) {
            templates.addClass('disable disable-element');
            var inforNoAppLink = Confluence.Blueprints.JiraReports.Dialog.showMessageNoAppLink({
                'isAdministrator': AJS.Meta.get("is-confluence-admin"),
                'contentPath': Confluence.getContextPath()
            });
            state.$container.find(".warningAppLink").append(inforNoAppLink);
            $(".create-dialog-create-button:visible").addClass('hidden');
        } else {
            templates
                .click(function () {
                    $(this).siblings().removeClass('selected');
                    $(this).addClass('selected');
                })
                .dblclick(function () {
                    $('.create-dialog-create-button:visible').click();
                });

            selectionContainer
                .attr('tabindex', 0)
                .keydown(function (event) {
                    var selected = selectionContainer.find('.selected');

                    if (event.keyCode == 38) { // up
                        event.preventDefault(); // prevents page behind the dialog from scrolling in FF
                        selected.removeClass('selected');
                        selected.prev().length ? selected.prev().addClass('selected') : templates.last().addClass('selected');
                    }
                    else if (event.keyCode == 40) { // down
                        event.preventDefault();
                        selected.removeClass('selected');
                        selected.next().length ? selected.next().addClass('selected') : templates.first().addClass('selected');
                    }
                });

            // CONFDEV-20419: If JIRA Reports are selected by hitting the 'enter' key in IE8, something causes
            // the selected report type to be submitted immediately, without giving the user a chance to view
            // or change the selection. This workaround ensures that we don't make a default selection until
            // the event handler for submit.selectreportPageId has already run.
            setTimeout(function () {
                templates.first().click();
                selectionContainer.focus();
            }, 0);
        }
    }

    function selectReportTypeSubmit(e, state) {
        var selectedTypeId = state.$container.find('.selected').attr('id');
        if (selectedTypeId === "jirareports-select-changelog") {
            state.nextPageId = "changelogPageId";
            state.wizardData.jiraReportType = Confluence.Blueprints.JiraReport.REPORT_TYPE_CHANGE_LOG;
        } else if (selectedTypeId === "jirareports-select-statusreport") {
            state.nextPageId = "statusreportPageId";
            state.wizardData.jiraReportType = Confluence.Blueprints.JiraReport.REPORT_TYPE_STATUS;
        } else {
            return false;
        }
    }

    function initMainDialog(e, state) {
        var callbackObjects = [Confluence.Blueprints.JiraReport.DynamicDialog, Confluence.Blueprints.JiraReport.StaticDialog];
        Confluence.Blueprints.JiraReport.init(state, callbackObjects);
        Confluence.Blueprints.JiraReport.setSelectedReportType(state.wizardData.jiraReportType);
        Confluence.Blueprints.JiraReport.loadServers();
    }

    function initStatusReportDialog(e, state) {
        initMainDialog(e, state);
        //temporary hide static/dynamic option
        $('#jira-report-type').parents('.field-group').addClass('hidden');
    }

    function changeLogSubmit(e, state) {
        if (Confluence.Blueprints.JiraReport.validateForm(state)) {
            Confluence.Blueprints.JiraReport.setupChangeLogSubmitData(state);
            return true;
        }
        return false;
    }

    function statusReportSubmit(e, state) {
        if (!Confluence.Blueprints.JiraReport.validateForm(state)) {
            return false;
        }

        Confluence.Blueprints.JiraReport.setupStatusReportSubmitData(state);
        state.pageData['statusreport-type'] = "jirareports-statusreport-dynamic";
        state.pageData['issues-list-type'] = "dynamic";
        state.pageData['contentTemplateKey'] = "jirareports-statusreport";
    }

    function prepareData() {
        Confluence.Blueprints.JiraReport.prepareData();
    }

    Confluence.Blueprint.setWizard('com.atlassian.confluence.plugins.confluence-software-blueprints:jirareports-item', function (wizard) {
        wizard.on("pre-render.selectreportPageId", prepareData);
        wizard.on("post-render.selectreportPageId", bindJiraSelector);
        wizard.on("submit.selectreportPageId", selectReportTypeSubmit);

        //for change log
        wizard.on("post-render.changelogPageId", initMainDialog);
        wizard.on("submit.changelogPageId", changeLogSubmit);

        //for status report
        wizard.on("post-render.statusreportPageId", initStatusReportDialog);
        wizard.on("submit.statusreportPageId", statusReportSubmit);

    });
})(AJS.$);
