define('confluence-search/collection/results', [
    'confluence-search/model/result',
    'confluence-search/utils',
    'ajs',
    'backbone',
    'underscore',
    'confluence/meta'
], function(
    ModelResult,
    searchUtils,
    AJS,
    Backbone,
    _,
    Meta
) {
    "use strict";

    return Backbone.Collection.extend({

        // search meta data
        totalSize: null,
        timeSpent: null,
        startIndex: null,
        pageSize: null,
        uuid: null,

        model: ModelResult,

        url: AJS.contextPath() + '/rest/searchv3/1.0/search',

        initialize: function (options) {
            _.extend(this, options);
        },

        parse: function (response) {
            this.totalSize = response.total;
            this.timeSpent = response.timeSpent;
            this.archivedResultsCount = response.archivedResultsCount;
            this.querySuggestion = response.querySuggestion;
            this.uuid = response.uuid;
            return response.results;
        },

        search: function (params) {
            // make sure we always have a startIndex and it's a number
            params.startIndex = +params.startIndex || 0;

            // add authenticated username to payload
            var fetchData = _.extend({}, params, {
                user: searchUtils.getRemoteUsername(),
                sessionUuid: Meta.get("search-query-session-uuid")
            });

            var searchError = _.bind(this.trigger, this, "searchComplete searchError", this, params);
            var searchUnauthorized = _.bind(this.trigger, this, "searchComplete searchUnauthorized", this, params);

            this.fetch({
                data: fetchData,
                success: _.bind(this.trigger, this, "searchComplete searchSuccess", this, params),
                statusCode: {
                    401: searchUnauthorized,
                    500: searchError
                }
            });

            this.trigger("search", params);
        }
    });
});