/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.rest;

import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.plugins.search.api.Searcher;
import com.atlassian.confluence.plugins.search.api.events.RemoteSearchPerformedEvent;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResultList;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/search")
@Produces(value={"application/json;charset=UTF-8"})
public class SearchResource {
    private static final Logger log = LoggerFactory.getLogger(SearchResource.class);
    private final Searcher luceneSearcher;
    private final Searcher searcherBySearchManager;
    private final SettingsManager settingsManager;
    private final TransactionTemplate transactionTemplate;
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;

    public SearchResource(@Qualifier(value="searcherv3") Searcher searcherv3, @Qualifier(value="searcherv2") Searcher searcherv2, SettingsManager settingsManager, TransactionTemplate transactionTemplate, EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.luceneSearcher = searcherv3;
        this.searcherBySearchManager = searcherv2;
        this.transactionTemplate = transactionTemplate;
        this.settingsManager = settingsManager;
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @AnonymousAllowed
    public Response search(@QueryParam(value="user") String user, @QueryParam(value="queryString") String query, @QueryParam(value="startIndex") @DefaultValue(value="0") int startIndex, @QueryParam(value="pageSize") @DefaultValue(value="10") int pageSize, @QueryParam(value="type") String type, @QueryParam(value="where") String where, @QueryParam(value="lastModified") String lastModified, @QueryParam(value="contributor") String contributor, @QueryParam(value="contributorUsername") String contributorUsername, @QueryParam(value="includeArchivedSpaces") boolean includeArchivedSpaces, @QueryParam(value="sessionUuid") String sessionUuid, @QueryParam(value="labels") Set<String> labels, @QueryParam(value="highlight") @DefaultValue(value="true") boolean highlight) {
        if (!Strings.isNullOrEmpty((String)user) && !user.equals(AuthenticatedUserThreadLocal.getUsername())) {
            return Response.status((int)401).build();
        }
        return (Response)this.transactionTemplate.execute(() -> {
            SearchQueryParameters.Builder builder = new SearchQueryParameters.Builder(query).startIndex(startIndex).pageSize(pageSize).pluggableContentType(this.pluginAccessor, type).where(where).contributor(Strings.isNullOrEmpty((String)contributorUsername) ? contributor : contributorUsername).includeArchivedSpaces(includeArchivedSpaces).highlight(highlight).labels(labels);
            if (!Strings.isNullOrEmpty((String)lastModified)) {
                DateRangeEnum lastModifiedDateRange = null;
                try {
                    lastModifiedDateRange = DateRangeEnum.valueOf((String)lastModified);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                builder.lastModified(lastModifiedDateRange);
            }
            SearchQueryParameters searchQueryParameters = builder.build();
            SearchResults searchResults = this.isESSearchEnabled() ? this.searcherBySearchManager.search(searchQueryParameters, false) : this.luceneSearcher.search(searchQueryParameters, false);
            SearchResultList searchResultList = new SearchResultList(searchResults.getResults(), searchResults.getTotalSize(), searchResults.getExtendedTotalSize(), searchResults.getUuid().toString(), searchResults.getTimeSpent());
            this.publishSearchPerformedEvent(searchQueryParameters, searchResults, sessionUuid);
            return Response.ok((Object)searchResultList).build();
        });
    }

    public boolean isESSearchEnabled() {
        return DarkFeatures.isDarkFeatureEnabled((String)"es.site.search") || DarkFeatures.isDarkFeatureEnabled((String)"es.site.search.odd");
    }

    private void publishSearchPerformedEvent(SearchQueryParameters searchQuery, SearchResults searchResults, String sessionUuid) {
        RemoteSearchPerformedEvent event;
        int totalSize = searchResults.getTotalSize();
        User user = AuthenticatedUserThreadLocal.getUser();
        if (StringUtils.isBlank((CharSequence)sessionUuid)) {
            Map<String, String> extraParams = Collections.emptyMap();
            SearchQuery search = searchQuery.toSearchV2Query(extraParams);
            event = new RemoteSearchPerformedEvent(this, search, user, totalSize);
        } else {
            SearchQuery search = searchQuery.toSearchV2Query((Map<String, String>)ImmutableMap.of((Object)"sessionUuid", (Object)sessionUuid));
            event = new SearchPerformedEvent((Object)this, search, user, totalSize);
        }
        this.eventPublisher.publish((Object)event);
    }
}

