/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query.v2search.elasticsearch;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.search.query.v2search.SiteTextSearchQuery;
import com.atlassian.confluence.search.v2.elasticsearch.ESFieldNameTranslator;
import com.atlassian.confluence.search.v2.elasticsearch.ESFieldType;
import com.atlassian.confluence.search.v2.elasticsearch.mapper.query.ESQueryMapper;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

@Internal
public class SiteTextSearchQueryMapper
implements ESQueryMapper<SiteTextSearchQuery> {
    public static final float CONTENT_SHINGLE_BOOST = 0.125f;

    public QueryBuilder map(SiteTextSearchQuery query) {
        if (!SiteTextSearchQuery.isQueryStringSyntax(query.getTextQuery())) {
            return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)query.getTextQuery(), (String[])new String[0]).field(ESFieldType.TEXT.addTypeToFieldname("title")).field(ESFieldType.TEXT.addTypeToFieldname("contentBody")).type(MultiMatchQueryBuilder.Type.MOST_FIELDS)).should((QueryBuilder)QueryBuilders.matchQuery((String)ESFieldType.TEXT.addTypeToFieldname("contentBody").concat(".shingles"), (Object)query.getTextQuery()).boost(0.125f));
        }
        return QueryBuilders.queryStringQuery((String)ESFieldNameTranslator.wildcardAllFieldsInQuery((String)query.getTextQuery())).field(ESFieldNameTranslator.wildcardField((String)"title")).field(ESFieldNameTranslator.wildcardField((String)"contentBody"));
    }

    public String getQueryKey() {
        return "siteSearch";
    }
}

