/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.plugins.search.query.MatchNoDocsFilter;
import com.atlassian.confluence.search.lucene.filter.MultiTermFilter;
import com.atlassian.confluence.search.lucene.filter.TermFilter;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;

public class SpaceCategoryFilter
extends Filter {
    private final LabelManager labelManager;
    private final SpaceCategoryEnum category;

    public SpaceCategoryFilter(LabelManager labelManager, SpaceCategoryEnum categoryName) {
        this.labelManager = labelManager;
        this.category = categoryName;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Filter spaceCategoryFilter = this.getFilterForCategory();
        if (spaceCategoryFilter != null) {
            return spaceCategoryFilter.getDocIdSet(context, acceptDocs);
        }
        int maxDoc = context.reader().maxDoc();
        OpenBitSet result = new OpenBitSet((long)maxDoc);
        result.set(0L, (long)maxDoc);
        return result;
    }

    private Filter getFilterForCategory() {
        switch (this.category) {
            case ALL: {
                return null;
            }
            case GLOBAL: {
                return this.getSpaceTypeFilter(SpaceType.GLOBAL.toString());
            }
            case PERSONAL: {
                return this.getSpaceTypeFilter(SpaceType.PERSONAL.toString());
            }
            case FAVOURITES: {
                return this.getFilterForFavourite();
            }
        }
        throw new IllegalArgumentException("Unknown space category: " + this.category);
    }

    private Filter getSpaceTypeFilter(String value) {
        return new TermFilter(new Term("space-type", value));
    }

    private Filter getFilterForFavourite() {
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        if (currentUser == null) {
            return new MatchNoDocsFilter();
        }
        List favouriteSpaces = this.labelManager.getFavouriteSpaces(currentUser.getName());
        MultiTermFilter multiTermFilter = new MultiTermFilter();
        for (Space favouriteSpace : favouriteSpaces) {
            multiTermFilter.addTerm(new Term("spacekey", favouriteSpace.getKey()));
        }
        return multiTermFilter;
    }
}

