/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.confluence.content.ContentType;
import com.atlassian.confluence.content.ContentTypeModuleDescriptor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.user.User;
import java.util.LinkedList;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonViewableContentTypeFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(NonViewableContentTypeFilterFactory.class);
    private final PluginAccessor pluginAccessor;

    public NonViewableContentTypeFilterFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Option<Filter> newFilter() {
        LinkedList<BytesRef> contentTypeModuleKeys = new LinkedList<BytesRef>();
        for (ContentTypeModuleDescriptor contentTypeModuleDescriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(ContentTypeModuleDescriptor.class)) {
            ContentType contentType = null;
            try {
                contentType = contentTypeModuleDescriptor.getModule();
            }
            catch (Exception e) {
                log.debug("Error creating module: " + contentTypeModuleDescriptor, (Throwable)e);
            }
            try {
                if (contentType != null && contentType.getPermissionDelegate().canView((User)AuthenticatedUserThreadLocal.get())) continue;
                contentTypeModuleKeys.add(new BytesRef((CharSequence)contentTypeModuleDescriptor.getContentType()));
            }
            catch (Exception e) {
                log.debug("Error: ", (Throwable)e);
            }
        }
        if (contentTypeModuleKeys.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)new ChainedFilter(new Filter[]{new TermsFilter("contentPluginKey", contentTypeModuleKeys)}, 2));
    }
}

