/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.confluence.plugins.search.query.LuceneQueryUtil;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class LuceneSpanQueryBuilder {
    private static final int TERMS_LIMIT = 6;
    public static final int BASE_SLOP = 5;
    public static final int SHINGLE_SIZE = 2;

    public Optional<Query> getQuery(String field, String queryString, Analyzer analyzer) {
        Set<String> tokens = LuceneQueryUtil.tokenize(analyzer, field, queryString);
        if (tokens.size() <= 1 || tokens.size() > 6) {
            return Optional.absent();
        }
        if (tokens.size() == 2) {
            Iterator<String> tokenIterator = tokens.iterator();
            SpanQuery[] spanTermQueries = new SpanQuery[]{new SpanTermQuery(new Term(field, tokenIterator.next())), new SpanTermQuery(new Term(field, tokenIterator.next()))};
            SpanNearQuery spanNearQuery = new SpanNearQuery(spanTermQueries, 5, false, false);
            return Optional.of((Object)spanNearQuery);
        }
        BooleanQuery query = new BooleanQuery(true);
        Set tokensPowerSet = Sets.powerSet(tokens);
        SpanTermQuery[] spanTermQueries = new SpanTermQuery[2];
        for (Set set : tokensPowerSet) {
            if (set.size() != 2) continue;
            int i = 0;
            for (String term : set) {
                spanTermQueries[i++] = new SpanTermQuery(new Term(field, term));
            }
            SpanNearQuery spanNearQuery = new SpanNearQuery((SpanQuery[])spanTermQueries, 5, false, false);
            query.add((Query)spanNearQuery, BooleanClause.Occur.SHOULD);
        }
        return Optional.of((Object)query);
    }
}

