/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class LuceneQueryUtil {
    public static Set<String> tokenize(Analyzer analyzer, String field, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        try {
            TokenStream tokenStream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            CharTermAttribute termAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                result.add(termAttribute.toString());
            }
            tokenStream.end();
            tokenStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

