/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.query;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.query.ApplyPrefixToLabelFunction;
import com.atlassian.confluence.plugins.search.query.DisabledContentTypeFilterFactory;
import com.atlassian.confluence.plugins.search.query.FilterFactory;
import com.atlassian.confluence.plugins.search.query.MatchNoDocsFilter;
import com.atlassian.confluence.plugins.search.query.NonViewableContentTypeFilterFactory;
import com.atlassian.confluence.plugins.search.query.SpaceCategoryFilter;
import com.atlassian.confluence.search.lucene.filter.ContentPermissionsFilter;
import com.atlassian.confluence.search.lucene.filter.SpaceFilter;
import com.atlassian.confluence.search.lucene.filter.SpacePermissionsFilterFactory;
import com.atlassian.confluence.search.lucene.filter.TermFilter;
import com.atlassian.confluence.search.lucene.filter.ViewUserProfilesPermissionsFilter;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResultType;
import com.atlassian.confluence.search.v2.lucene.mapper.CustomContentTypeQueryMapper;
import com.atlassian.confluence.search.v2.query.CustomContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Option;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.util.BytesRef;

public class LuceneFilterFactory
implements FilterFactory {
    private final SpacePermissionsFilterFactory spacePermissionsFilterFactory;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final LabelManager labelManager;
    private final SpacePermissionManager spacePermissionManager;
    private final CustomContentTypeQueryMapper customContentTypeQueryMapper;
    private final DisabledContentTypeFilterFactory disabledContentTypeFilterFactory;
    private final NonViewableContentTypeFilterFactory nonViewableContentTypeFilterFactory;
    private List<Filter> commonFilters;

    public LuceneFilterFactory(SpaceManager spaceManager, UserAccessor userAccessor, LabelManager labelManager, SpacePermissionManager spacePermissionManager, DisabledContentTypeFilterFactory disabledContentTypeFilterFactory, NonViewableContentTypeFilterFactory nonViewableContentTypeFilterFactory) {
        this.spacePermissionManager = spacePermissionManager;
        this.disabledContentTypeFilterFactory = disabledContentTypeFilterFactory;
        this.nonViewableContentTypeFilterFactory = nonViewableContentTypeFilterFactory;
        this.spacePermissionsFilterFactory = (SpacePermissionsFilterFactory)ContainerManager.getComponent((String)"spacePermissionsFilterFactory");
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.labelManager = labelManager;
        this.customContentTypeQueryMapper = new CustomContentTypeQueryMapper();
        this.initCommonFilters();
    }

    private void initCommonFilters() {
        this.commonFilters = new ArrayList<Filter>();
        this.commonFilters.add((Filter)new TermFilter(new Term("confluence-document-type", SearchResultType.CONTENT.name())));
        this.commonFilters.add(this.getIgnoredTypeFilter());
        this.commonFilters.add(this.getIgnoredUsersFilter());
    }

    @Override
    public List<Filter> getFilters(SearchQueryParameters queryParameters) {
        DateRangeQuery.DateRange lastModifiedDateRange;
        Date fromDate;
        SearchQuery pluginContentTypeQuery;
        Collection archivedSpaceKeys;
        LinkedList<Filter> filters = new LinkedList<Filter>();
        filters.addAll(this.commonFilters);
        filters.addAll(this.getPermissionsFilters((User)AuthenticatedUserThreadLocal.get()));
        if (!queryParameters.isIncludeArchivedSpaces() && StringUtils.isBlank((CharSequence)queryParameters.getSpaceKey()) && (archivedSpaceKeys = this.spaceManager.getAllSpaceKeys(SpaceStatus.ARCHIVED)).size() > 0) {
            filters.add((Filter)new SpaceFilter(archivedSpaceKeys, true));
        }
        if (queryParameters.getSpaceCategory() != null && queryParameters.getSpaceCategory() != SpaceCategoryEnum.ALL) {
            filters.add(new SpaceCategoryFilter(this.labelManager, queryParameters.getSpaceCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryParameters.getSpaceKey())) {
            filters.add((Filter)new SpaceFilter(Collections.singleton(queryParameters.getSpaceKey())));
        }
        if (queryParameters.getContentType() != null) {
            filters.add((Filter)new TermFilter(new Term("type", queryParameters.getContentType().getRepresentation())));
        }
        if (!queryParameters.getLabels().isEmpty()) {
            Iterable labels = Iterables.transform(queryParameters.getLabels(), (Function)ApplyPrefixToLabelFunction.getInstance());
            LinkedList labelTerms = new LinkedList();
            for (Option item : labels) {
                item.foreach(label -> labelTerms.add(new Term("label", StringUtils.trim((String)label))));
            }
            filters.add((Filter)new TermsFilter(labelTerms));
        }
        if (queryParameters.getPluginContentType() != null && (pluginContentTypeQuery = queryParameters.getPluginContentType().getQuery()) instanceof CustomContentTypeQuery) {
            CustomContentTypeQuery customContentTypeQuery = (CustomContentTypeQuery)pluginContentTypeQuery;
            filters.add((Filter)new QueryWrapperFilter(this.customContentTypeQueryMapper.convertToLuceneQuery(customContentTypeQuery)));
        }
        if (queryParameters.getLastModified() != null && (fromDate = (lastModifiedDateRange = queryParameters.getLastModified().dateRange()).getFrom()) != null) {
            filters.add((Filter)new TermRangeFilter("modified", new BytesRef((CharSequence)LuceneUtils.dateToString((Date)fromDate)), null, lastModifiedDateRange.isIncludeFrom(), false));
        }
        if (queryParameters.getContributor() != null) {
            filters.add(this.getContributorFilter(queryParameters));
        }
        this.disabledContentTypeFilterFactory.newFilter().foreach(filters::add);
        this.nonViewableContentTypeFilterFactory.newFilter().foreach(filters::add);
        return filters;
    }

    private List<Filter> getPermissionsFilters(User user) {
        LinkedList<Filter> filters = new LinkedList<Filter>();
        List groupNames = user == null ? null : this.userAccessor.getGroupNames(user);
        filters.add((Filter)new ContentPermissionsFilter(user, (Iterable)groupNames));
        if (!this.userAccessor.isSuperUser(user)) {
            filters.add((Filter)this.spacePermissionsFilterFactory.create(user));
            filters.add((Filter)new ViewUserProfilesPermissionsFilter(user, this.spacePermissionManager));
        }
        return filters;
    }

    private Filter getContributorFilter(SearchQueryParameters queryParameters) {
        ConfluenceUser user = this.userAccessor.getUserByName(queryParameters.getContributor());
        if (user != null) {
            Filter[] contributorFilters = new Filter[]{new TermFilter(new Term("creatorName", user.getKey().getStringValue())), new TermFilter(new Term("lastModifiers", user.getKey().getStringValue()))};
            return new ChainedFilter(contributorFilters, 0);
        }
        return new MatchNoDocsFilter();
    }

    private Filter getIgnoredTypeFilter() {
        Filter[] typeFilters = new Filter[]{new TermsFilter("type", new BytesRef[]{new BytesRef((CharSequence)"space"), new BytesRef((CharSequence)"globaldescription")})};
        return new ChainedFilter(typeFilters, 2);
    }

    private Filter getIgnoredUsersFilter() {
        Filter[] userFilters = new Filter[]{new TermsFilter("isDeactivatedUser", new BytesRef[]{new BytesRef((CharSequence)"true")}), new TermsFilter("isExternallyDeletedUser", new BytesRef[]{new BytesRef((CharSequence)"true")})};
        return new ChainedFilter(userFilters, 2);
    }
}

