/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.model;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.content.ui.AttachmentUiSupport;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.plugins.search.api.model.SearchExplanation;
import com.atlassian.confluence.plugins.search.api.model.SearchResult;
import com.atlassian.confluence.plugins.search.api.model.SearchResultContainer;
import com.atlassian.confluence.plugins.search.model.LastModificationFormatter;
import com.atlassian.confluence.plugins.search.model.SearchResultBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

@Internal
class AttachmentResultBuilder
implements SearchResultBuilder {
    private final LastModificationFormatter lastModificationFormatter;
    private final ContextPathHolder contextPathHolder;
    private final User user;

    AttachmentResultBuilder(LastModificationFormatter lastModificationFormatter, ContextPathHolder contextPathHolder, User user) {
        this.lastModificationFormatter = lastModificationFormatter;
        this.contextPathHolder = contextPathHolder;
        this.user = user;
    }

    @Override
    public SearchResult newSearchResult(Function<String, String> getFieldValue, Supplier<String> getTitleWithHighlights, Supplier<String> getExcerptWithHighlights, Supplier<SearchExplanation> getExplanation) {
        String friendlyDate = this.lastModificationFormatter.format(getFieldValue.apply("modified"), this.user);
        long id = SearchResultBuilder.getId(getFieldValue.apply("handle"));
        String url = getFieldValue.apply("downloadPath");
        return new SearchResult(id, getFieldValue.apply("type"), getTitleWithHighlights.get(), getExcerptWithHighlights.get(), url, this.getSearchResultContainer(getFieldValue), friendlyDate, getExplanation.get(), this.getMetadata(getFieldValue));
    }

    private Map<String, String> getMetadata(Function<String, String> getFieldValue) {
        String title = getFieldValue.apply("title");
        String mimeType = getFieldValue.apply("attachment-mime-type");
        String fileExtension = StringUtils.substringAfterLast((String)title, (String)".");
        AttachmentUiSupport.AttachmentInfo attachmentInfo = AttachmentUiSupport.getAttachmentInfo((String)mimeType, (String)fileExtension);
        return ImmutableMap.of((Object)"attachmentMimeType", (Object)Strings.nullToEmpty((String)mimeType), (Object)"cssClass", (Object)Strings.nullToEmpty((String)attachmentInfo.getCssClass()));
    }

    private SearchResultContainer getSearchResultContainer(Function<String, String> getFieldValue) {
        String spaceName = getFieldValue.apply("space-name");
        String spaceUrl = this.contextPathHolder.getContextPath() + new Space(getFieldValue.apply("spacekey")).getUrlPath();
        String contentRealTitle = getFieldValue.apply("content.realTitle");
        String contentUrlPath = getFieldValue.apply("content.urlPath");
        SearchResultContainer contentPage = SearchResultContainer.create(contentRealTitle, this.contextPathHolder.getContextPath() + contentUrlPath);
        return SearchResultContainer.create(spaceName, spaceUrl, contentPage);
    }
}

