/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.boosting;

import com.atlassian.confluence.plugin.ModuleDescriptorCache;
import com.atlassian.confluence.plugin.descriptor.search.LuceneBoostingStrategyModuleDescriptor;
import com.atlassian.confluence.plugins.search.api.boosting.ExplainableBoostingStrategy;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.lucene.boosting.BoostingStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;

public class PluggableBoostingStrategy
implements ExplainableBoostingStrategy {
    public static final double EPSILON = 1.0E-4;
    private final ModuleDescriptorCache<LuceneBoostingStrategyModuleDescriptor> moduleDescriptorCache;

    public PluggableBoostingStrategy(ModuleDescriptorCache<LuceneBoostingStrategyModuleDescriptor> moduleDescriptorCache) {
        this.moduleDescriptorCache = moduleDescriptorCache;
    }

    public float boost(IndexReader reader, int doc, float score) throws IOException {
        LuceneBoostingStrategyModuleDescriptor descriptor;
        Collection descriptors = this.moduleDescriptorCache.getDescriptors();
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext() && (score = (descriptor = (LuceneBoostingStrategyModuleDescriptor)iterator.next()).getModule().boost(reader, doc, score)) != 0.0f) {
        }
        return score;
    }

    public float boost(IndexReader reader, Map<String, Object> params, int doc, float score) throws IOException {
        LuceneBoostingStrategyModuleDescriptor descriptor;
        Collection descriptors = this.moduleDescriptorCache.getDescriptors();
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext() && (score = (descriptor = (LuceneBoostingStrategyModuleDescriptor)iterator.next()).getModule().boost(reader, params, doc, score)) != 0.0f) {
        }
        return score;
    }

    public float boost(IndexReader reader, SearchQueryParameters searchQueryParameters, int doc, float score) throws IOException {
        LuceneBoostingStrategyModuleDescriptor descriptor;
        Collection descriptors = this.moduleDescriptorCache.getDescriptors();
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext() && (score = (descriptor = (LuceneBoostingStrategyModuleDescriptor)iterator.next()).getModule().boost(reader, searchQueryParameters, doc, score)) != 0.0f) {
        }
        return score;
    }

    @Override
    public Explanation explain(AtomicReaderContext context, int doc, Explanation delegate) throws IOException {
        Explanation result = delegate;
        Collection descriptors = this.moduleDescriptorCache.getDescriptors();
        for (LuceneBoostingStrategyModuleDescriptor descriptor : descriptors) {
            BoostingStrategy module = descriptor.getModule();
            if (module instanceof ExplainableBoostingStrategy) {
                ExplainableBoostingStrategy explainableBoostingStrategy = (ExplainableBoostingStrategy)module;
                result = explainableBoostingStrategy.explain(context, doc, result);
                continue;
            }
            float previousScore = result.getValue();
            float outputScore = module.boost((IndexReader)context.reader(), doc, previousScore);
            if (!((double)Math.abs(outputScore - previousScore) > 1.0E-4)) continue;
            Explanation explanation = new Explanation();
            explanation.setValue(outputScore);
            explanation.setDescription(descriptor.getKey());
            explanation.addDetail(result);
            result = explanation;
        }
        return result;
    }
}

