/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.boosting;

import com.atlassian.confluence.plugin.CompositeModuleDescriptorPredicate;
import com.atlassian.confluence.plugin.ModuleDescriptorCache;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import java.util.Collection;

public class ModuleDescriptorCacheFactory {
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;

    public ModuleDescriptorCacheFactory(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
    }

    public <T extends ModuleDescriptor<?>> ModuleDescriptorCache<T> create(final Class<T> moduleDescriptorClass) {
        ModuleDescriptorCache cache = new ModuleDescriptorCache(moduleDescriptorClass);
        this.pluginEventManager.register((Object)cache);
        cache.initialize(new ModuleDescriptorCache.Initializer<T>(){

            public Collection<? extends T> getDescriptors() {
                return ModuleDescriptorCacheFactory.this.pluginAccessor.getEnabledModuleDescriptorsByClass(moduleDescriptorClass);
            }
        });
        return cache;
    }

    public <T extends ModuleDescriptor<?>> ModuleDescriptorCache<T> create(Class<T> moduleDescriptorClass, final ModuleDescriptorPredicate moduleDescriptorPredicate) {
        ModuleDescriptorCache cache = new ModuleDescriptorCache(moduleDescriptorClass, moduleDescriptorPredicate);
        this.pluginEventManager.register((Object)cache);
        cache.initialize(new ModuleDescriptorCache.Initializer<T>(){

            public Collection<? extends T> getDescriptors() {
                EnabledModulePredicate enabledModulePredicate = new EnabledModulePredicate(ModuleDescriptorCacheFactory.this.pluginAccessor);
                return ModuleDescriptorCacheFactory.this.pluginAccessor.getModuleDescriptors((ModuleDescriptorPredicate)new CompositeModuleDescriptorPredicate(new ModuleDescriptorPredicate[]{enabledModulePredicate, moduleDescriptorPredicate}));
            }
        });
        return cache;
    }
}

