/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.api.model;

import com.google.common.base.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchResultContainer {
    private String name;
    private String url;
    private SearchResultContainer child;

    private SearchResultContainer() {
    }

    public static SearchResultContainer create(String name, String url, SearchResultContainer child) {
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)url)) {
            return new SearchResultContainer(name, url, child);
        }
        return null;
    }

    public static SearchResultContainer create(String name, String url) {
        return SearchResultContainer.create(name, url, null);
    }

    public SearchResultContainer(String name, String url) {
        this(name, url, null);
    }

    public SearchResultContainer(String name, String url, SearchResultContainer child) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        this.name = name;
        this.url = url;
        this.child = child;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public SearchResultContainer getChild() {
        return this.child;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResultContainer)) {
            return false;
        }
        SearchResultContainer that = (SearchResultContainer)o;
        return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getUrl(), (Object)that.getUrl()) && Objects.equal((Object)this.getChild(), (Object)that.getChild());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getUrl(), this.getChild()});
    }
}

