/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.actions;

import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.search.plugin.ContentTypeSearchDescriptor;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SearchActionParameterMigrator {
    private Function<SearchQueryParameters, String> convertToTextField = s -> Strings.isNullOrEmpty((String)s.getQuery()) ? null : "siteSearch ~ " + this.quote(s.getQuery());
    private Function<SearchQueryParameters, String> convertToSpaceField = s -> Strings.isNullOrEmpty((String)s.getSpaceKey()) ? null : "space = " + this.quote(s.getSpaceKey());
    private Function<SearchQueryParameters, String> convertToSpaceTypeField = s -> {
        String spaceType;
        if (s.getSpaceCategory() == null) {
            return null;
        }
        switch (s.getSpaceCategory()) {
            case GLOBAL: {
                spaceType = "global";
                break;
            }
            case PERSONAL: {
                spaceType = "personal";
                break;
            }
            case FAVOURITES: {
                spaceType = "favourite";
                break;
            }
            case ALL: {
                return null;
            }
            default: {
                throw new NotImplementedServiceException("Space category type not implemented: " + s.getSpaceCategory());
            }
        }
        return "space.type = \"" + spaceType + "\"";
    };
    private Function<SearchQueryParameters, String> convertToTypeField = s -> {
        ContentTypeEnum contentType = s.getContentType();
        if (contentType != null) {
            String typeStr = contentType == ContentTypeEnum.SPACE_DESCRIPTION || contentType == ContentTypeEnum.PERSONAL_SPACE_DESCRIPTION ? "space" : (contentType == ContentTypeEnum.PERSONAL_INFORMATION ? "user" : contentType.toString());
            return "type = " + this.quote(typeStr);
        }
        ContentTypeSearchDescriptor pluginContentType = s.getPluginContentType();
        if (pluginContentType != null) {
            return "type = " + this.quote(pluginContentType.getIdentifier());
        }
        return null;
    };
    private Function<SearchQueryParameters, String> convertToLastModifiedField = s -> {
        String nowFunctionArgument;
        if (s.getLastModified() == null) {
            return null;
        }
        switch (s.getLastModified()) {
            case LASTDAY: {
                nowFunctionArgument = "-1d";
                break;
            }
            case LASTTWODAYS: {
                nowFunctionArgument = "-2d";
                break;
            }
            case LASTWEEK: {
                nowFunctionArgument = "-1w";
                break;
            }
            case LASTMONTH: {
                nowFunctionArgument = "-1M";
                break;
            }
            case LASTSIXMONTHS: {
                nowFunctionArgument = "-6M";
                break;
            }
            case LASTYEAR: {
                nowFunctionArgument = "-1y";
                break;
            }
            case LASTTWOYEARS: {
                nowFunctionArgument = "-2y";
                break;
            }
            default: {
                throw new NotImplementedServiceException("No implementation for date range: " + s.getLastModified().toString());
            }
        }
        return "lastmodified >= now('" + nowFunctionArgument + "')";
    };
    private Function<SearchQueryParameters, String> convertToContributorField = s -> s.getContributor() == null ? null : "contributor = " + this.quote(s.getContributor());
    private Function<SearchQueryParameters, String> convertToLabelsField = s -> {
        if (s.getLabels() == null) {
            return null;
        }
        if (s.getLabels().isEmpty()) {
            return null;
        }
        String result = s.getLabels().stream().filter(label -> !Strings.isNullOrEmpty((String)label)).map(label -> "label = \"" + label + "\"").collect(Collectors.joining(" AND "));
        return result;
    };

    private SearchActionParameterMigrator() {
    }

    private String quote(String stringToQuote) {
        return "\"" + stringToQuote.replaceAll("\"", "\\\\\"") + "\"";
    }

    public static String migrate(SearchQueryParameters searchQueryParameters) {
        SearchActionParameterMigrator searchActionParameterMigrator = new SearchActionParameterMigrator();
        ArrayList parameterConverters = Lists.newArrayList((Object[])new Function[]{searchActionParameterMigrator.convertToTextField, searchActionParameterMigrator.convertToSpaceField, searchActionParameterMigrator.convertToSpaceTypeField, searchActionParameterMigrator.convertToTypeField, searchActionParameterMigrator.convertToLastModifiedField, searchActionParameterMigrator.convertToContributorField, searchActionParameterMigrator.convertToLabelsField});
        return parameterConverters.stream().map(f -> (String)f.apply(searchQueryParameters)).filter(p -> p != null).collect(Collectors.joining(" AND "));
    }
}

