/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugins.search.LuceneSearcher;
import com.atlassian.confluence.plugins.search.V2Searcher;
import com.atlassian.confluence.plugins.search.api.model.SearchExplanation;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.plugins.search.query.QueryFactory;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import java.util.List;
import org.apache.lucene.search.Query;

public class ExplainAction
extends ConfluenceActionSupport {
    private QueryFactory queryFactory;
    private LuceneSearcher searcherv3;
    private V2Searcher searcherv2;
    private String queryString;
    private long[] contentIds;
    private Query query;
    private List<SearchExplanation> explanationsForSpecifiedContentIds;
    private SearchResults searchResults;

    public String execute() throws Exception {
        this.query = this.queryFactory.getQuery(this.queryString);
        SearchQueryParameters queryParameters = new SearchQueryParameters.Builder(this.queryString).build();
        if (this.contentIds != null) {
            this.explanationsForSpecifiedContentIds = this.isESSearchEnabled() ? this.searcherv2.explain(queryParameters, this.contentIds) : this.searcherv3.explain(queryParameters, this.contentIds);
        }
        this.searchResults = this.isESSearchEnabled() ? this.searcherv2.search(queryParameters, true) : this.searcherv3.search(queryParameters, true);
        return "success";
    }

    public String fixExplanation(String explanation) {
        return explanation.replaceAll("\n\\), product of", "\\), product of");
    }

    public String formatQuery(Query query) {
        if (query == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int counter = 0;
        for (char c : query.toString().toCharArray()) {
            if (c == '(' && counter == 0) {
                result.append('\n');
            }
            if (c == '(') {
                ++counter;
            }
            if (c == ')') {
                --counter;
            }
            result.append(c);
        }
        return result.toString();
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setSearcherv2(V2Searcher searcherv2) {
        this.searcherv2 = searcherv2;
    }

    public void setSearcherv3(LuceneSearcher searcherv3) {
        this.searcherv3 = searcherv3;
    }

    public SearchResults getSearchResults() {
        return this.searchResults;
    }

    public List<SearchExplanation> getExplanationsForSpecifiedContentIds() {
        return this.explanationsForSpecifiedContentIds;
    }

    public void setContentIds(long[] contentIds) {
        this.contentIds = contentIds;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public boolean isESSearchEnabled() {
        return DarkFeatures.isDarkFeatureEnabled((String)"es.site.search") || DarkFeatures.isDarkFeatureEnabled((String)"es.site.search.odd");
    }
}

