/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.search;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.search.SearchConstants;
import com.atlassian.confluence.plugins.search.api.Searcher;
import com.atlassian.confluence.plugins.search.api.model.SearchExplanation;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResult;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.plugins.search.boosting.BoostingQuery;
import com.atlassian.confluence.plugins.search.event.V3QueryExecutionEvent;
import com.atlassian.confluence.plugins.search.model.SearchResultBuilder;
import com.atlassian.confluence.plugins.search.model.SearchResultBuilderFactory;
import com.atlassian.confluence.plugins.search.query.FilterFactory;
import com.atlassian.confluence.plugins.search.query.QueryFactory;
import com.atlassian.confluence.search.lucene.extractor.HTMLSearchableTextExtractor;
import com.atlassian.confluence.search.summary.NoFormatFormatter;
import com.atlassian.confluence.search.summary.WrappingFormatter;
import com.atlassian.confluence.search.v2.lucene.boosting.BM25LSimilarity;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.base.CharMatcher;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.similarities.Similarity;
import org.xml.sax.SAXException;

public class LuceneSearcher
implements Searcher {
    private final Analyzer analyzer;
    private final ILuceneConnection luceneConnection;
    private final QueryFactory queryFactory;
    private final FilterFactory filterFactory;
    private final ContentEntityManager contentEntityManager;
    private final SearchResultBuilderFactory resultBuilderFactory;
    private final EventPublisher eventPublisher;
    private static final float K_1 = 1.25f;
    private static final float B = 0.3f;
    private static final float DELTA = 0.5f;
    private final Similarity similarity = new BM25LSimilarity(1.25f, 0.3f, 0.5f);

    public LuceneSearcher(LuceneAnalyzerFactory luceneAnalyzerFactory, ILuceneConnection luceneConnection, QueryFactory queryFactory, FilterFactory filterFactory, ContentEntityManager contentEntityManager, SearchResultBuilderFactory resultBuilderFactory, EventPublisher eventPublisher) {
        this.analyzer = luceneAnalyzerFactory.createAnalyzer();
        this.luceneConnection = luceneConnection;
        this.queryFactory = queryFactory;
        this.filterFactory = filterFactory;
        this.contentEntityManager = contentEntityManager;
        this.resultBuilderFactory = resultBuilderFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public SearchResults search(SearchQueryParameters queryParameters, boolean explain) {
        long startTime = System.nanoTime();
        Query query = this.queryFactory.getQuery(queryParameters.getQuery());
        List<Filter> filters = this.filterFactory.getFilters(queryParameters);
        ChainedFilter chainedFilter = filters.size() > 0 ? new ChainedFilter(filters.toArray(new Filter[filters.size()]), 1) : null;
        LinkedList<SearchResult> searchResults = new LinkedList<SearchResult>();
        int[] totalResults = new int[1];
        boolean highLight = queryParameters.isHighlight();
        Query highlightQuery = LuceneSearcher.getInnerQuery(query);
        TitleWithHighlightsExtractor titleWithHighlightsExtractor = new TitleWithHighlightsExtractor(highlightQuery, this.analyzer, highLight);
        ExcerptWithHighlightsExtractor excerptWithHighlightsExtractor = new ExcerptWithHighlightsExtractor(highlightQuery, this.analyzer, highLight);
        int startIndex = queryParameters.getStartIndex();
        int pageSize = queryParameters.getPageSize();
        this.luceneConnection.withSearch(indexSearcher -> {
            int numResults = startIndex + 1 + pageSize;
            int maxHitsToCollect = Math.min(numResults, SearchConstants.MAX_NUM_RESULTS);
            long start = System.currentTimeMillis();
            indexSearcher.setSimilarity(this.similarity);
            TopScoreDocCollector topScoreDocCollector = TopScoreDocCollector.create((int)maxHitsToCollect, (boolean)true);
            indexSearcher.search(query, (Filter)chainedFilter, (Collector)topScoreDocCollector);
            TopDocs topDocs = topScoreDocCollector.topDocs(startIndex, pageSize);
            totalResults[0] = topDocs.totalHits;
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document document = indexSearcher.getIndexReader().document(scoreDoc.doc);
                String explanation = explain ? indexSearcher.explain(query, scoreDoc.doc).toString() : null;
                SearchResultBuilder resultBuilder = this.resultBuilderFactory.createBuilder(document.get("type"), (User)AuthenticatedUserThreadLocal.get());
                long id = SearchResultBuilder.getId(document.get("handle"));
                ContentEntityObject contentEntity = this.contentEntityManager.getById(id);
                SearchResult searchResult = resultBuilder.newSearchResult(arg_0 -> ((Document)document).get(arg_0), () -> titleWithHighlightsExtractor.apply(arg_0 -> ((Document)document).get(arg_0)), () -> excerptWithHighlightsExtractor.apply(arg_0 -> ((Document)document).get(arg_0)), () -> new SearchExplanation(explanation, contentEntity));
                searchResults.add(searchResult);
            }
            long end = System.currentTimeMillis();
            this.eventPublisher.publish((Object)new V3QueryExecutionEvent(start, end));
        });
        int numberOfResultsInArchivedSpace = 0;
        if (totalResults[0] == 0 && !queryParameters.isIncludeArchivedSpaces()) {
            numberOfResultsInArchivedSpace = this.findNumberOfResultsInArchivedSpace(queryParameters);
        }
        return new SearchResults(totalResults[0], numberOfResultsInArchivedSpace, searchResults, (System.nanoTime() - startTime) / 1000000L, query.toString());
    }

    @Override
    public List<SearchExplanation> explain(SearchQueryParameters queryParameters, long[] contentIds) {
        LinkedList<SearchExplanation> explanations = new LinkedList<SearchExplanation>();
        Query query = this.queryFactory.getQuery(queryParameters.getQuery());
        this.luceneConnection.withSearch(indexSearcher -> {
            if (contentIds != null) {
                for (long contentId : contentIds) {
                    ContentEntityObject contentEntity = this.contentEntityManager.getById(contentId);
                    if (contentEntity == null) continue;
                    BooleanQuery explainQuery = new BooleanQuery();
                    explainQuery.add((Query)new TermQuery(new Term("confluence-document-type", "CONTENT")), BooleanClause.Occur.MUST);
                    explainQuery.add((Query)new TermQuery(new Term("handle", new HibernateHandle((Searchable)contentEntity).toString())), BooleanClause.Occur.MUST);
                    TopDocs topDocs = indexSearcher.search((Query)explainQuery, 1);
                    if (topDocs == null || topDocs.totalHits != 1) continue;
                    String explanation = indexSearcher.explain(query, topDocs.scoreDocs[0].doc).toString();
                    explanations.add(new SearchExplanation(explanation, contentEntity));
                }
            }
        });
        return explanations;
    }

    private int findNumberOfResultsInArchivedSpace(SearchQueryParameters queryParameters) {
        SearchQueryParameters searchWithArchivedSpaces = SearchQueryParameters.newSearchQueryParameters(queryParameters).includeArchivedSpaces(true).build();
        SearchResults extendedSearchResults = this.search(searchWithArchivedSpaces, false);
        return extendedSearchResults.getTotalSize();
    }

    private static Query getInnerQuery(Query query) {
        if (query instanceof BoostingQuery) {
            return ((BoostingQuery)query).getContextQuery();
        }
        return query;
    }

    private static String formatBodyTextHighlights(String bodyTextHighlights) {
        String newHighlights = bodyTextHighlights;
        if (bodyTextHighlights != null) {
            newHighlights = CharMatcher.WHITESPACE.trimAndCollapseFrom((CharSequence)bodyTextHighlights, ' ');
            if (!StringUtils.isEmpty((CharSequence)bodyTextHighlights)) {
                newHighlights = newHighlights + "\u2026";
            }
        }
        return newHighlights;
    }

    private static String stripTags(String htmlContent) {
        try {
            return HTMLSearchableTextExtractor.stripTags((String)htmlContent);
        }
        catch (SAXException e) {
            return GeneralUtil.htmlEncode((String)htmlContent);
        }
    }

    private static class TitleWithHighlightsExtractor
    implements Function<Function<String, String>, String> {
        private final Highlighter highlighter;
        private final Analyzer analyzer;

        TitleWithHighlightsExtractor(Query query, Analyzer analyzer, boolean highlight) {
            this.analyzer = analyzer;
            this.highlighter = highlight ? new Highlighter((Formatter)new WrappingFormatter("@@@hl@@@", "@@@endhl@@@"), (Scorer)new QueryScorer(query)) : new Highlighter((Formatter)NoFormatFormatter.getInstance(), (Scorer)new QueryScorer(query));
            this.highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(255));
        }

        @Override
        public String apply(Function<String, String> getFieldValue) {
            String titleTextHighlights = "";
            String titleText = getFieldValue.apply("title");
            if (StringUtils.isNotBlank((CharSequence)titleText)) {
                try {
                    titleTextHighlights = this.highlighter.getBestFragment(this.analyzer, "title", LuceneSearcher.stripTags(titleText));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isBlank((CharSequence)titleTextHighlights)) {
                    titleTextHighlights = LuceneSearcher.stripTags(titleText);
                }
                return titleTextHighlights;
            }
            return "";
        }
    }

    private static class ExcerptWithHighlightsExtractor
    implements Function<Function<String, String>, String> {
        private final Highlighter highlighter;
        private final Analyzer analyzer;

        ExcerptWithHighlightsExtractor(Query query, Analyzer analyzer, boolean highlight) {
            this.analyzer = analyzer;
            this.highlighter = highlight ? new Highlighter((Formatter)new WrappingFormatter("@@@hl@@@", "@@@endhl@@@"), (Scorer)new QueryScorer(query)) : new Highlighter((Formatter)NoFormatFormatter.getInstance(), (Scorer)new QueryScorer(query));
            this.highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(180));
        }

        @Override
        public String apply(Function<String, String> getFieldValue) {
            String bodyTextHighlights = "";
            String bodyText = getFieldValue.apply("contentBody");
            String titleText = getFieldValue.apply("title");
            if (StringUtils.isNotBlank((CharSequence)(bodyText = StringUtils.removeStart((String)bodyText, (String)titleText)))) {
                try {
                    bodyTextHighlights = this.highlighter.getBestFragment(this.analyzer, "contentBody", LuceneSearcher.stripTags(bodyText));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isBlank((CharSequence)bodyTextHighlights)) {
                    String excerpt = getFieldValue.apply("excerpt");
                    bodyTextHighlights = LuceneSearcher.stripTags(excerpt == null ? "" : excerpt);
                }
            }
            return LuceneSearcher.formatBodyTextHighlights(bodyTextHighlights);
        }
    }
}

