/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.schedule.admin.support;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;

public class CronExpressionValidator {
    private CronExpressionValidator() {
    }

    public static List<Date> getFutureSchedules(String cronExpressionValue, int limit) throws ParseException {
        return CronExpressionValidator.getFutureSchedules(cronExpressionValue, limit, null);
    }

    public static List<Date> getFutureSchedules(String cronExpressionValue, int limit, Date fromDate) throws ParseException {
        if (fromDate == null) {
            fromDate = new Date();
        }
        ArrayList<Date> futureSchedules = new ArrayList<Date>(limit);
        CronExpression cronExpression = new CronExpression(cronExpressionValue);
        Date nextRunTime = cronExpression.getNextValidTimeAfter(fromDate);
        while (nextRunTime != null && futureSchedules.size() < limit) {
            futureSchedules.add(nextRunTime);
            nextRunTime = cronExpression.getNextValidTimeAfter(nextRunTime);
        }
        return futureSchedules;
    }

    public static boolean isValid(String cronExpressionValue) {
        try {
            new CronExpression(cronExpressionValue);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

