/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.schedule.admin.action;

import com.atlassian.confluence.plugins.schedule.admin.action.AbstractViewAction;
import com.atlassian.confluence.schedule.ManagedScheduledCronJob;
import com.atlassian.confluence.schedule.ManagedScheduledJob;
import com.atlassian.confluence.schedule.ManagedScheduledSimpleJob;
import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.ScheduledJobStatus;
import com.atlassian.confluence.schedule.managers.ManagedScheduledJobRegistry;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewScheduledJobsAction
extends AbstractViewAction {
    private static final long serialVersionUID = 1L;
    private List<ScheduledJobStatus> jobs;
    private ManagedScheduledJobRegistry jobRegistry;

    public List<ScheduledJobStatus> getJobs() {
        return this.jobs;
    }

    public ManagedScheduledJob getManagedScheduledJob(ScheduledJobKey key) {
        return this.jobRegistry.getManagedScheduledJob(key);
    }

    public boolean isCronJob(ManagedScheduledJob job) {
        return ManagedScheduledJob.isCronJob((ManagedScheduledJob)job);
    }

    public <T extends ManagedScheduledJob> T getManagedScheduledJob(ScheduledJobKey key, Class<T> type) {
        ManagedScheduledJob managedJob = this.jobRegistry.getManagedScheduledJob(key);
        if (type.isInstance(managedJob)) {
            return (T)managedJob;
        }
        return null;
    }

    public ManagedScheduledCronJob getManagedScheduledCronJob(ScheduledJobKey key) {
        return this.getManagedScheduledJob(key, ManagedScheduledCronJob.class);
    }

    public ManagedScheduledSimpleJob getManagedScheduledSimpleJob(ScheduledJobKey key) {
        return this.getManagedScheduledJob(key, ManagedScheduledSimpleJob.class);
    }

    public String getCronExpression(ScheduledJobKey key) {
        return this.scheduledJobManager.getCronExpression(key);
    }

    public Long getRepeatInterval(ScheduledJobKey key) {
        return this.scheduledJobManager.getRepeatInterval(key);
    }

    public String execute() throws Exception {
        this.jobs = this.scheduledJobManager.getScheduledJobs();
        Collections.sort(this.jobs, new ScheduledJobStatusComparator());
        return "success";
    }

    public void setManagedScheduledJobRegistry(ManagedScheduledJobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    private class ScheduledJobStatusComparator
    implements Comparator<ScheduledJobStatus> {
        private Map<String, String> translations = new HashMap<String, String>();

        private ScheduledJobStatusComparator() {
        }

        @Override
        public int compare(ScheduledJobStatus s1, ScheduledJobStatus s2) {
            return this.getTranslatedName(s1).compareToIgnoreCase(this.getTranslatedName(s2));
        }

        private String getTranslatedName(ScheduledJobStatus s1) {
            String jobId = s1 != null ? String.valueOf(s1.getJobId()) : "null";
            String translation = this.translations.get(jobId);
            if (translation == null) {
                translation = ViewScheduledJobsAction.this.getText("scheduledjob.desc." + jobId);
                if (translation == null) {
                    translation = s1.getJobId();
                }
                this.translations.put(s1.getJobId(), translation);
            }
            return translation;
        }
    }
}

