/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.schedule.admin.action;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugins.schedule.admin.support.CronExpressionValidator;
import com.atlassian.confluence.schedule.ScheduledJobKey;
import com.atlassian.confluence.schedule.managers.ScheduledJobManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import org.apache.commons.lang3.StringUtils;

public class ChangeCronJobScheduleAction
extends ConfluenceActionSupport
implements Beanable {
    private ScheduledJobManager scheduledJobManager;
    private String group;
    private String id;
    private String cronExpression;
    private Result result;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    public String execute() throws Exception {
        this.result = this.validateInput();
        if (this.result.getError() != null) {
            return "error";
        }
        this.scheduledJobManager.updateCronJobSchedule(new ScheduledJobKey(this.group, this.id), this.cronExpression);
        return "success";
    }

    public Object getBean() {
        return this.result;
    }

    public void setScheduledJobManager(ScheduledJobManager scheduledJobManager) {
        this.scheduledJobManager = scheduledJobManager;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    private Result validateInput() {
        if (StringUtils.isEmpty((CharSequence)this.group)) {
            return new Result(this.getText("scheduledjob.error.group.missing"));
        }
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            return new Result(this.getText("scheduledjob.error.id.missing"));
        }
        if (!CronExpressionValidator.isValid(this.cronExpression)) {
            return new Result(this.getText("scheduledjob.error.cronExpression.invalid"));
        }
        return new Result();
    }

    public static class Result {
        private final String error;

        private Result(String error) {
            this.error = error;
        }

        private Result() {
            this((String)null);
        }

        public String getError() {
            return this.error;
        }
    }
}

