/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.websudo;

import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.oauth.util.RequestAnnotations;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfluenceWebSudoManager
implements com.atlassian.sal.api.websudo.WebSudoManager {
    private final WebSudoManager internalWebSudoManager;
    private final SettingsManager settingsManager;

    public ConfluenceWebSudoManager(SettingsManager settingsManager, WebSudoManager internalWebSudoManager) {
        this.internalWebSudoManager = (WebSudoManager)Preconditions.checkNotNull((Object)internalWebSudoManager, (Object)"internalWebSudoManager");
        this.settingsManager = (SettingsManager)Preconditions.checkNotNull((Object)settingsManager, (Object)"settingsManager");
    }

    @Override
    public boolean canExecuteRequest(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        return !this.internalWebSudoManager.isEnabled() || RequestAnnotations.isOAuthRequest((HttpServletRequest)httpServletRequest) || this.internalWebSudoManager.hasValidSession(session);
    }

    @Override
    public void enforceWebSudoProtection(HttpServletRequest request, HttpServletResponse response) {
        String encoding = this.settingsManager.getGlobalSettings().getDefaultEncoding();
        try {
            String queryString = request.getQueryString();
            String pathInfo = request.getPathInfo();
            String destination = request.getServletPath() + (null != pathInfo ? pathInfo : "") + (null != queryString ? "?" + queryString : "");
            response.sendRedirect(request.getContextPath() + "/authenticate.action?destination=" + URLEncoder.encode(destination, encoding));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to redirect to /authenticate.action");
        }
    }

    @Override
    public void willExecuteWebSudoRequest(HttpServletRequest httpServletRequest) throws WebSudoSessionException {
        if (!this.canExecuteRequest(httpServletRequest)) {
            throw new WebSudoSessionException("Invalid request: Not in a WebSudo session");
        }
        this.internalWebSudoManager.markWebSudoRequest(httpServletRequest);
    }
}

