/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.net;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.TrustedRequestFactory;
import com.atlassian.sal.confluence.net.HttpTimeoutParameters;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.HttpClientTrustedRequest;
import com.atlassian.sal.core.net.HttpClientTrustedRequestFactory;
import com.atlassian.sal.core.net.SystemPropertiesConnectionConfig;

public class ConfluenceHttpClientTrustedRequestFactory
implements TrustedRequestFactory<HttpClientTrustedRequest> {
    private final SettingsManager settingsManager;
    private final HttpClientTrustedRequestFactory trustedRequestFactory;

    public ConfluenceHttpClientTrustedRequestFactory(SettingsManager settingsManager, HttpClientTrustedRequestFactory trustedRequestFactory) {
        this.settingsManager = settingsManager;
        this.trustedRequestFactory = trustedRequestFactory;
    }

    @Override
    public HttpClientTrustedRequest createTrustedRequest(Request.MethodType methodType, String url) {
        HttpClientTrustedRequest request = this.trustedRequestFactory.createTrustedRequest(methodType, url);
        this.adjustTimeouts((HttpClientRequest)request);
        return request;
    }

    private void adjustTimeouts(HttpClientRequest request) {
        ConfluenceHttpParameters confluenceHttpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters();
        SystemPropertiesConnectionConfig systemPropConfigs = new SystemPropertiesConnectionConfig();
        request.setConnectionTimeout(HttpTimeoutParameters.getConnectionTimeoutFrom(systemPropConfigs, confluenceHttpParameters));
        request.setSoTimeout(HttpTimeoutParameters.getSocketTimeoutFrom(systemPropConfigs, confluenceHttpParameters));
    }

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        HttpClientRequest request = this.trustedRequestFactory.createRequest(methodType, url);
        this.adjustTimeouts(request);
        return request;
    }

    @Override
    public boolean supportsHeader() {
        return this.trustedRequestFactory.supportsHeader();
    }
}

