/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.net;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.confluence.net.HttpTimeoutParameters;
import com.atlassian.sal.core.net.HttpClientRequest;
import com.atlassian.sal.core.net.HttpClientRequestFactory;
import com.atlassian.sal.core.net.SystemPropertiesConnectionConfig;

public class ConfluenceHttpClientRequestFactory
extends HttpClientRequestFactory {
    private final SettingsManager settingsManager;

    public ConfluenceHttpClientRequestFactory(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public HttpClientRequest createRequest(Request.MethodType methodType, String url) {
        HttpClientRequest request = super.createRequest(methodType, url);
        ConfluenceHttpParameters confluenceHttpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters();
        SystemPropertiesConnectionConfig systemPropConfigs = new SystemPropertiesConnectionConfig();
        request.setConnectionTimeout(HttpTimeoutParameters.getConnectionTimeoutFrom(systemPropConfigs, confluenceHttpParameters));
        request.setSoTimeout(HttpTimeoutParameters.getSocketTimeoutFrom(systemPropConfigs, confluenceHttpParameters));
        return request;
    }
}

