/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.confluence.lifecycle;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.confluence.setup.SetupCompleteEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.lifecycle.LifecycleManager;
import com.atlassian.sal.confluence.lifecycle.ServiceExecutionStrategy;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class TenantAwareLifecycleManager
implements LifecycleManager,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TenantAwareLifecycleManager.class);
    private final AtomicReference<State> currentState = new AtomicReference<State>(State.BEFORE_INIT);
    private final CopyOnWriteArraySet<ServiceReference> lifecycleReferences = new CopyOnWriteArraySet();
    private final LoadingCache<Tenant, AtomicInteger> tenantPositions = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Tenant, AtomicInteger>(){

        public AtomicInteger load(Tenant key) throws Exception {
            return new AtomicInteger();
        }
    });
    private final AtlassianBootstrapManager bootstrapManager;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final TenantAccessor tenantAccessor;
    private final ExecutorService executorService;

    public TenantAwareLifecycleManager(AtlassianBootstrapManager bootstrapManager, EventListenerRegistrar eventListenerRegistrar, TenantAccessor tenantAccessor, ExecutorService executorService) {
        this.bootstrapManager = bootstrapManager;
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.tenantAccessor = tenantAccessor;
        this.executorService = executorService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.start();
    }

    @EventListener
    public void onSetupComplete(SetupCompleteEvent event) {
        this.start();
    }

    @EventListener
    public void onTenantArrived(TenantArrivedEvent event) {
        if (State.BEFORE_INIT != this.currentState.get()) {
            this.triggerForTenants((Iterable<Tenant>)ImmutableSet.of((Object)event.getTenant())).claim();
        }
    }

    public void onLifecycleExport(ServiceReference lifecycleReference) {
        this.lifecycleReferences.add(lifecycleReference);
        if (State.BEFORE_INIT != this.currentState.get()) {
            this.triggerForTenants(this.tenantAccessor.getAvailableTenants()).claim();
        }
    }

    @Override
    public boolean isApplicationSetUp() {
        return this.bootstrapManager.isSetupComplete();
    }

    @Override
    public void start() {
        if (!this.isApplicationSetUp()) {
            return;
        }
        Iterable tenants = this.tenantAccessor.getAvailableTenants();
        if (!tenants.iterator().hasNext()) {
            return;
        }
        if (this.currentState.compareAndSet(State.BEFORE_INIT, State.INIT)) {
            this.triggerForTenants(this.tenantAccessor.getAvailableTenants()).claim();
            Preconditions.checkState((boolean)this.currentState.compareAndSet(State.INIT, State.AFTER_INIT));
        }
    }

    private Promise triggerForTenants(Iterable<Tenant> tenants) {
        ImmutableList.Builder perTenantLifecycleFutures = ImmutableList.builder();
        for (Tenant tenant : tenants) {
            perTenantLifecycleFutures.add((Object)Promises.forFuture(this.executorService.submit(new PerTenantLifecycleExecution(tenant))));
        }
        return Promises.when((Promise[])((Promise[])perTenantLifecycleFutures.build().toArray((Object[])new Promise[0])));
    }

    public void setLifecycleReferences(List<ServiceReference> lifecycleReferences) {
        this.lifecycleReferences.addAll(lifecycleReferences);
    }

    protected abstract ServiceExecutionStrategy<LifecycleAware> createServiceExecutionStrategy();

    private class PerTenantLifecycleExecution
    implements Runnable {
        private final Tenant tenant;

        private PerTenantLifecycleExecution(Tenant tenant) {
            this.tenant = tenant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicInteger tenantPositionMonitor = (AtomicInteger)TenantAwareLifecycleManager.this.tenantPositions.getUnchecked((Object)this.tenant);
            log.debug("acquire position {} for {}", (Object)tenantPositionMonitor, (Object)this.tenant);
            AtomicInteger atomicInteger = tenantPositionMonitor;
            synchronized (atomicInteger) {
                int tenantPosition = tenantPositionMonitor.get();
                log.debug("acquired position {} for {}", (Object)tenantPositionMonitor, (Object)this.tenant);
                if (tenantPosition < TenantAwareLifecycleManager.this.lifecycleReferences.size()) {
                    ServiceExecutionStrategy<LifecycleAware> serviceExecutionStrategy = TenantAwareLifecycleManager.this.createServiceExecutionStrategy();
                    tenantPosition = this.addLifecycles(tenantPosition, serviceExecutionStrategy);
                    serviceExecutionStrategy.trigger();
                }
                tenantPositionMonitor.set(tenantPosition);
            }
        }

        private Integer addLifecycles(Integer tenantPosition, ServiceExecutionStrategy<LifecycleAware> serviceExecutionStrategy) {
            ServiceReference[] lifeServiceReferences = TenantAwareLifecycleManager.this.lifecycleReferences.toArray(new ServiceReference[0]);
            while (tenantPosition < lifeServiceReferences.length) {
                ServiceReference lifecycleReference = lifeServiceReferences[tenantPosition];
                if (lifecycleReference.getBundle() != null) {
                    Preconditions.checkState((boolean)serviceExecutionStrategy.add(lifecycleReference, this.tenant, lifecycleAware -> {
                        this.triggerLifecycleAsTenant((LifecycleAware)lifecycleAware);
                        return null;
                    }), (String)"Lifecycle reference %s for %s could not be added. There should always be a catch all strategy configured.", (Object[])new Object[]{lifecycleReference, this.tenant});
                }
                Integer n = tenantPosition;
                Integer n2 = tenantPosition = Integer.valueOf(tenantPosition + 1);
            }
            return tenantPosition;
        }

        private void triggerLifecycleAsTenant(LifecycleAware lifecycleAware) {
            try {
                TenantAwareLifecycleManager.this.tenantAccessor.asTenant(this.tenant, () -> {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    lifecycleAware.onStart();
                    log.info("{}#onStart took {}ms", (Object)lifecycleAware.getClass().getName(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                    return null;
                });
            }
            catch (TenantUnavailableException e) {
                Throwables.propagate((Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    log.error("Unable to start component: " + lifecycleAware.getClass().getName(), e.getCause());
                }
                log.error("Unable to start component: " + lifecycleAware.getClass().getName(), (Throwable)e);
            }
        }
    }

    private static enum State {
        BEFORE_INIT,
        INIT,
        AFTER_INIT;

    }
}

